package com.bizvane.connectorservice.entity.vo;


import lombok.Data;

/**
 * 微盟系统token
 */
@Data
public class WmSystemTokenVo {

    /**
     * access_token 的值，是微盟 OpenAPI 的调用凭证，有效期为 2 小时。
     * 使用相同的 client_id 与 shop_id 请求时，2 小时内获取到的 access_token 相同。
     * 请注意缓存，避免滥刷 token 造成限流。
     */
    private String access_token;

    /**
     * access_token 类型，目前只支持 bearer。
     */
    private String token_type;

    /**
     * access_token 的有效期，单位秒。
     */
    private Long expires_in;

    /**
     * access_token 的有效期，单位秒。
     */
    private String scope;

    /**
     * 微盟商业操作系统 ID（BOSID）。WOS 体系的店铺授权才会返回 BOSID，新云体系的店铺授权则不会返回 BOSID
     */
    private String business_operation_system_id;

    /**
     * 微盟商家店铺 ID（PID）
     */
    private String public_account_id;

    /**
     * 微盟商家公众号 ID（B 端 WID）。
     */
    private String business_id;
}
