package com.bizvane.connectorservice.interfaces.rpc;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.param.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 微盟对接接口入口
 *     用于调用微盟对接的接口操作入口
 * @anthor shifeng
 * @version  1.0.1
 * 2022-11-23 18:21:50
 */
@FeignClient(value = "${feign.client.connector.name}",path = "${feign.client.connector.path}/wm")
public interface WmConnectServiceFeign {

    /**
     * 会员新增接口
     * param   memberInfoModelParams
     * @return Result
     * 2022-11-23 18:48:47
     */
    @RequestMapping(value ="addMemberInfoTowm", method = RequestMethod.POST)
    Result<Object> addMemberInfoTowm(@RequestBody List<MemberInfoModelParam> memberInfoModelParams);

    /**
     * 会员等级变更接口
     *     crm会员等级发生变化时，同步给微盟
     * @param  memberInfoModelParam 手机号码
     * @return Result
     * 2022-11-23 18:48:47
     */
    @RequestMapping(value ="memberLevelChangeTowm", method = RequestMethod.POST)
    Result<Object> memberLevelChangeTowm(@RequestBody MemberInfoModelParam memberInfoModelParam);

    /**
     * 更新会员基本信息
     *     crm会员信息发生变化时，同步给微盟
     * @param  memberInfoModelParam
     * @return Result
     * 2022-11-23 18:48:47
     */
    @RequestMapping(value ="memberInfoChangeTowm", method = RequestMethod.POST)
    Result<Object> memberInfoChangeTowm(@RequestBody MemberInfoModelParam memberInfoModelParam);

    /**
     * 更新会员服务关系信息
     *     crm会员服务关系信息发生变化时，同步给微盟
     * @param  memberInfoModelParam
     * @return Result
     * 2022-11-23 18:48:47
     */
    @RequestMapping(value ="memberServiceChangeTowm", method = RequestMethod.POST)
    Result<Object> memberServiceChangeTowm(@RequestBody MemberInfoModelParam memberInfoModelParam);

    /**
     * 会员官方标签同步接口
     *     crm会员官方标签同步接口
     * @param  memberLabelInfoParams
     * @return Result
     * 2022-11-23 18:48:47
     */
    @RequestMapping(value ="memberLabelChangeTowm", method = RequestMethod.POST)
    Result<Object> memberLabelChangeTowm(@RequestBody List<MemberLabelInfoParam> memberLabelInfoParams);

    /**
     * 会员官方标签属性同步接口
     *     crm会员官方标签同步接口
     * @param  memberLabelAttrParam
     * @return Result
     * 2022-11-23 18:48:47
     */
    @RequestMapping(value ="memberLabelAttrChangeTowm", method = RequestMethod.POST)
    Result<Object> memberLabelAttrChangeTowm(@RequestBody List<MemberLabelAttrParam> memberLabelAttrParam);

    /**
     * 会员贴标签功能
     * @param  memberInfoModelParams
     * @return Result
     * 2022-11-23 18:48:47
     */
    @RequestMapping(value ="memberAddLabelChangeTowm", method = RequestMethod.POST)
    Result<Object> memberAddLabelChangeTowm(@RequestBody List<MemberInfoModelParam> memberInfoModelParams);

    /**
     * 会员撕标签标签功能
     * @param  memberInfoModelParam
     * @return Result
     * 2022-11-23 18:48:47
     */
    @RequestMapping(value ="memberRemoveLabelChangeTowm", method = RequestMethod.POST)
    Result<Object> memberRemoveLabelChangeTowm(@RequestBody MemberInfoModelParam memberInfoModelParam);

    /**
     * 会员订单同步接口
     * @param
     * @return Result
     * 2022-11-23 18:48:47
     */
    @RequestMapping(value ="memberOrderTowm", method = RequestMethod.POST)
    Result<Object> memberOrderTowm();

    /**
     * 会员订单退单同步接口
     * @param
     * @return Result
     * 2022-11-23 18:48:47
     */
    @RequestMapping(value ="memberOrderCancelTowm", method = RequestMethod.POST)
    Result<Object> memberOrderCancelTowm();

    /**
     * 优惠券定义同步
     * @param
     * @return
     * 2022-11-23 18:48:47
     */
    @RequestMapping(value ="couponDefineTowm", method = RequestMethod.POST)
    Result<Object> couponDefineTowm(@RequestBody CouponDefinitionParam param);

    /**
     * 优惠券作废
     * @param
     * @return
     * 2022-11-23 18:48:47
     */
    @RequestMapping(value ="unuseCouponTowm", method = RequestMethod.POST)
    Result<Object> unuseCouponTowm(@RequestBody CouponCancelParam param);

    /**
     * 优惠券核销
     * @param
     * @return
     * 2022-11-23 18:48:47
     */
    @RequestMapping(value ="useCouponEntityTowm", method = RequestMethod.POST)
    Result<Object> useCouponEntityTowm(@RequestBody CouponUseParam param);

    /**
     * 会员领劵
     * @return
     */
    @RequestMapping(value ="couponBindMember", method = RequestMethod.POST)
    Result<Object> couponBindMember(@RequestBody CouponBindMemberParam param);

}
