/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.connectorservice.util;

import com.alibaba.fastjson.JSON;
import com.bizvane.connectorservice.config.WMSystemConfig;
import com.bizvane.connectorservice.constant.WmSystemConstant;
import com.bizvane.connectorservice.entity.vo.WmSystemTokenVo;
import com.bizvane.connectorservice.util.HttpClientUtil;
import com.bizvane.connectorservice.util.RedisCacheUtils;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WmSystemTokenUtils {
    private static final Logger log = LoggerFactory.getLogger(WmSystemTokenUtils.class);
    @Autowired
    private RedisCacheUtils redisCacheUtils;
    @Autowired
    private WMSystemConfig wmSystemConfig;

    public String getWmSystemToken() {
        WmSystemTokenVo wmSystemTokenByRedis = this.getWmSystemTokenByRedis();
        return wmSystemTokenByRedis.getAccess_token();
    }

    private WmSystemTokenVo getWmSystemTokenByRedis() {
        WmSystemTokenVo tokenVo;
        log.info("getWmSystemTokenByRedis,1. \u5c1d\u8bd5\u4eceredis\u4e2d\u83b7\u53d6");
        Object wmSystemTokenVo = this.redisCacheUtils.getCacheObject("wm_system_token_redis_key");
        if (wmSystemTokenVo != null && null != (tokenVo = (WmSystemTokenVo)JSON.parseObject((String)wmSystemTokenVo.toString(), WmSystemTokenVo.class))) {
            return tokenVo;
        }
        log.info("getWmSystemTokenByRedis,2. \u7f13\u5b58\u4e2d\u6ca1\u6709token, \u5c31\u5237\u65b0token");
        return this.refreshToken();
    }

    private WmSystemTokenVo refreshToken() {
        WmSystemTokenVo tokenVo = this.findWmSystemToken();
        if (tokenVo == null || StringUtils.isBlank((String)tokenVo.getAccess_token())) {
            log.info("\u83b7\u53d6\u5fae\u76dftoken\u5931\u8d25");
            throw new RuntimeException("\u83b7\u53d6\u5fae\u76dftoken\u5931\u8d25");
        }
        this.redisCacheUtils.setCacheObject("wm_system_token_redis_key", JSON.toJSONString((Object)tokenVo), WmSystemConstant.DEFAULT_WM_SYSTEM_TOKEN_REDIS_TIMEOUT, TimeUnit.SECONDS);
        return tokenVo;
    }

    private WmSystemTokenVo findWmSystemToken() {
        WmSystemTokenVo wmSystemTokenVo = null;
        String url = this.packingWmSystemInterface("/fuwu/b/oauth2/token");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("grant_type", this.wmSystemConfig.getGrantType());
        headers.put("client_id", this.wmSystemConfig.getClientId());
        headers.put("client_secret", this.wmSystemConfig.getClientSecret());
        url = url + "?grant_type=" + this.wmSystemConfig.getGrantType() + "&client_id=" + this.wmSystemConfig.getClientId() + "&client_secret=" + this.wmSystemConfig.getClientSecret();
        log.info("findWmSystemToken,url{},headers:{}", (Object)url, (Object)JSON.toJSONString(headers));
        String response = HttpClientUtil.doPost(url, null);
        log.info("findWmSystemToken,response:{}", (Object)response);
        if (StringUtils.isNotBlank((String)response)) {
            wmSystemTokenVo = (WmSystemTokenVo)JSON.parseObject((String)response, WmSystemTokenVo.class);
        }
        return wmSystemTokenVo;
    }

    public String packingWmSystemInterface(String url) {
        return this.wmSystemConfig.getWmSystemDNS() + url;
    }
}

