/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.connectorservice.util;

import com.bizvane.connectorservice.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtils {
    private static Logger log = LoggerFactory.getLogger((String)RestUtils.class.getName());
    private static final int TIME_OUT = 8000;
    public static final String POST = "post";
    public static final Integer SUCCESS_STATUS = 200;

    public static String sendRequestBuff(String apiUrl, String params, String method) throws Exception {
        return RestUtils.sendRequestBuff(apiUrl, params, method, false);
    }

    public static String sendRequestBuff(String apiUrl, String params, String method, boolean keepAlive) throws Exception {
        return RestUtils.sendRequestBuff(apiUrl, params, null, method, keepAlive);
    }

    public static String sendRequestBuff(String url, String params, JSONObject head, String method, boolean keepAlive) throws Exception {
        if (head == null) {
            head = new JSONObject();
        }
        method = StringUtil.valueOf(method, "POST");
        log.info("jh_third_interface sendRequestBuff params:" + params);
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestMethod(method.toUpperCase());
        String key = null;
        Iterator headKeys = head.keys();
        while (headKeys.hasNext()) {
            key = (String)headKeys.next();
            conn.setRequestProperty(key, head.optString(key));
        }
        if (keepAlive) {
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setConnectTimeout(60000);
        } else {
            conn.setConnectTimeout(8000);
        }
        conn.setDoInput(true);
        if (POST.equalsIgnoreCase(method)) {
            conn.setUseCaches(false);
        }
        if (StringUtil.isNotNull(params)) {
            conn.setDoOutput(true);
            conn.getOutputStream().write(params.getBytes("utf-8"));
        }
        conn.connect();
        log.info(RestUtils.toCustomString(conn.getHeaderFields()));
        if (conn.getResponseCode() != SUCCESS_STATUS.intValue()) {
            log.error("jh_third_interface sendRequestBuff server status error ->" + conn.getResponseCode());
            throw new Exception("\u8bf7\u6c42url\u5931\u8d25");
        }
        BufferedInputStream bis = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        bis = new BufferedInputStream(conn.getInputStream());
        int len = 0;
        while ((len = bis.read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        String contentType = conn.getContentType();
        String charset = RestUtils.getChareset(conn.getContentType());
        String resultString = baos.toString(charset);
        conn.disconnect();
        log.info("jh_third_interface sendRequestBuff RestUtils result : {} , contentType :{}" + resultString, (Object)contentType);
        return resultString;
    }

    public static String getChareset(String contentType) {
        int i = contentType == null ? -1 : contentType.indexOf("charset=");
        return i == -1 ? "UTF-8" : contentType.substring(i + 8);
    }

    private static String toCustomString(Map ht) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        for (Object key : ht.keySet()) {
            Object v = ht.get(key);
            if (v == null) {
                buf.append(key + ":=" + null + lineSeparator);
                break;
            }
            if (v instanceof Collection) {
                v = RestUtils.toString(((Collection)v).toArray());
            } else if (v.getClass().isArray()) {
                v = RestUtils.toString((Object[])v);
            }
            buf.append(key + ":=" + v + lineSeparator);
        }
        return buf.toString();
    }

    public static String toString(Object[] s) {
        try {
            if (s == null || s.length == 0) {
                return "null";
            }
            if (s.length == 1) {
                return s[0] + "";
            }
            String ret = "";
            for (int i = 0; i < s.length - 1; ++i) {
                if (s[i].getClass().isArray()) {
                    ret = ret + RestUtils.toString((Object[])s[i]) + ",";
                }
                ret = ret + s[i] + ",";
            }
            ret = ret + s[s.length - 1];
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "internal error";
        }
    }
}

