package com.bizvane.connectorservice.interfaces.base;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.vo.IntegralOrderRequestVo;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author admin
 * @date
 */
public interface AddIntegralOrderService {

    /**
     * 积分商品订单同步
     * @param requestVO 所有参数
     * @return Result
     * @throws Exception 异常
     */
    default Result addIntegralOrder(IntegralOrderRequestVo requestVO) throws Exception{
        return Result.returnStr(0,"default新增积分商品订单成功");
    };

    /**
     * [标准积分订单]订单发货
     * @param requestVO
     * @return
     */
    default Result<String> integralOrderShippped(@RequestBody IntegralOrderRequestVo requestVO) throws Exception {
        return Result.returnStr(0,"default[标准积分订单]订单发货成功");
    }

    /**
     * [标准积分订单]订单收货签收
     * @param requestVO
     * @return
     */
    @PostMapping("integralOrderReceipted")
    default Result<String> integralOrderReceipted(@RequestBody IntegralOrderRequestVo requestVO) throws Exception {
        return Result.returnStr(0,"default[标准积分订单]订单收货签收成功");
    }
}
