package com.bizvane.connectorservice.entity.common;

import com.bizvane.connectorservice.entity.base.BaseModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author liuying
 * @date 2018/8/21
 * @description
 */
@ToString
public class MemberModifyGradeRequestVO extends BaseModel {

    /**
     * 旧等级编号
     */
    private String oldLevelCode;

    /**
     * 新等级编号
     */
    private String newLevelCode;

    /**
     * 详情
     */
    private String deatil;

    /**
     * 线下会员id
     */
    private String erpId;

    /**
     * 线下会员卡号
     */
    private String offlineCardNo;

    /**
     * 雷朵 顾客姓名
     * */
    private String name;

    /**
     * 雷朵 会员生日 pattern = "yyyyMMdd"
     */
    private String birthday;

    /**
     * 雷朵 性别
     * */
    private String gender;

    /**
     * 雷朵 手机号
     * */
    private String phone;

    /**
     * 雷朵 rado-ds标志
     * */
    private Boolean radoFlag = Boolean.FALSE;

    /**
     * 雷朵 新等级名称
     * */
    private String newLevelName;

    public String getNewLevelName() {
        return newLevelName;
    }

    public void setNewLevelName(String newLevelName) {
        this.newLevelName = newLevelName;
    }

    /**
     * 雷朵 sap更新时间
     * */
    private String modifiedTime;

    public String getModifiedTime() {
        return modifiedTime;
    }

    public void setModifiedTime(String modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public String getBirthday() {
        return birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public Boolean getRadoFlag() {
        return radoFlag;
    }

    public void setRadoFlag(Boolean radoFlag) {
        this.radoFlag = radoFlag;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getOfflineCardNo() {
        return offlineCardNo;
    }

    public void setOfflineCardNo(String offlineCardNo) {
        this.offlineCardNo = offlineCardNo;
    }

    public String getOldLevelCode() {
        return oldLevelCode;
    }

    public void setOldLevelCode(String oldLevelCode) {
        this.oldLevelCode = oldLevelCode;
    }

    public String getNewLevelCode() {
        return newLevelCode;
    }

    public void setNewLevelCode(String newLevelCode) {
        this.newLevelCode = newLevelCode;
    }

    public String getDeatil() {
        return deatil;
    }

    public void setDeatil(String deatil) {
        this.deatil = deatil;
    }

    public String getErpId() {
        return erpId;
    }

    public void setErpId(String erpId) {
        this.erpId = erpId;
    }
}
