package com.bizvane.connectorservice.entity.common;

import com.bizvane.connectorservice.entity.base.BaseModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author liuying
 * @date 2018/8/9
 * @description
 */
@ToString
public class MemberInfoUpdateRequestVO extends BaseModel {


    private String erpId;
    /**
     * 微信用户的openId
     */
    private String openId;

    /**
     * 微信用户的unionId
     */
    private String unionId;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 会员姓名
     */
    private String name;

    /**
     * 等级Code
     */
    private String levelCode;

    /**
     * 会员性别(1男   0女)
     */
    private String gender;

    /**
     * 会员生日 pattern = "yyyyMMdd"
     */
    private String birthday;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 区县
     */
    private String county;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 线下卡号
     */
    private String offlineCardNo;

    /**
     * 开卡门店编号
     */
    private String openStoreCode;

    /**
     * 开卡导购编号
     */
    private String openGuideCode;

    /**
     * 服务门店编号
     */
    private String serviceStoreCode;

    /**
     * 服务导购编号
     */
    private String serviceGuideCode;


    /**
     * 业务唯一编号
     */
    private String memberUUID;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 自定义拓展字段,格式,json字符串
     */
    private String extend;

    /**
     * 当前重试次数
     */
    private int retryCount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 身份证号 361
     */
    private String idCard;

    /**
     * 全渠道会员卡ids
     */
    private String allChannelIds;

    /**
     * cyyz
     * 绑卡时间回写线下
     * */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date bindCardTime;

    /**
     * 手机区域号
     * */
    private String phoneAreaCode;

    /**
     * 有赞openId
     * */
    private String yzOpenId;

    /**
     * 雷朵 rado-ds服务
     * */
    private Boolean radoFlag = Boolean.FALSE;

    /**
     * 雷朵 新等级编号
     */
    private String newLevelCode;

    /**
     * 雷朵 新等级名称
     */
    private String newLevelName;

    /**
     * 雷朵 导购名称
     * */
    private String serviceGuideName;

    /**
     * 会员备注
     */
    private String memberComment;

    /**
     * 开卡日期
     */
    private String openCardTime;

    /**
     * 会员来源渠道id
     */
    private Integer openCardChannelId;

    /**
     * 会员来源渠道描述
     */
    private String openCardChannelName;

    /**
     * 推荐人会员卡号
     */
    private String InviterCardNo;

    /**
     * 推荐人会员姓名
     */
    private String InviterName;

    /**
     * 自建应用外部联系人ID
     */
    private String applicationExternalId;


    public String getNewLevelName() {
        return newLevelName;
    }

    public void setNewLevelName(String newLevelName) {
        this.newLevelName = newLevelName;
    }

    /**
     * 雷朵 sap更新时间
     * */
    private String modifiedTime;

    public String getMemberComment() {
        return memberComment;
    }

    public void setMemberComment(String memberComment) {
        this.memberComment = memberComment;
    }

    public String getModifiedTime() {
        return modifiedTime;
    }

    public void setModifiedTime(String modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public String getNewLevelCode() {
        return newLevelCode;
    }

    public void setNewLevelCode(String newLevelCode) {
        this.newLevelCode = newLevelCode;
    }

    public String getServiceGuideName() {
        return serviceGuideName;
    }

    public void setServiceGuideName(String serviceGuideName) {
        this.serviceGuideName = serviceGuideName;
    }

    public Boolean getRadoFlag() {
        return radoFlag;
    }

    public void setRadoFlag(Boolean radoFlag) {
        this.radoFlag = radoFlag;
    }

    public String getYzOpenId() {
        return yzOpenId;
    }

    public void setYzOpenId(String yzOpenId) {
        this.yzOpenId = yzOpenId;
    }

    public String getPhoneAreaCode() {
        return phoneAreaCode;
    }

    public void setPhoneAreaCode(String phoneAreaCode) {
        this.phoneAreaCode = phoneAreaCode;
    }

    public Date getBindCardTime() {
        return bindCardTime;
    }

    public void setBindCardTime(Date bindCardTime) {
        this.bindCardTime = bindCardTime;
    }

    public int getRetryCount() {
        return retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String getExtend() {
        return extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMemberUUID() {
        return memberUUID;
    }

    public void setMemberUUID(String memberUUID) {
        this.memberUUID = memberUUID;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLevelCode() {
        return levelCode;
    }

    public void setLevelCode(String levelCode) {
        this.levelCode = levelCode;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getBirthday() {
        return birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCounty() {
        return county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getOfflineCardNo() {
        return offlineCardNo;
    }

    public void setOfflineCardNo(String offlineCardNo) {
        this.offlineCardNo = offlineCardNo;
    }

    public String getOpenStoreCode() {
        return openStoreCode;
    }

    public void setOpenStoreCode(String openStoreCode) {
        this.openStoreCode = openStoreCode;
    }

    public String getOpenGuideCode() {
        return openGuideCode;
    }

    public void setOpenGuideCode(String openGuideCode) {
        this.openGuideCode = openGuideCode;
    }

    public String getServiceStoreCode() {
        return serviceStoreCode;
    }

    public void setServiceStoreCode(String serviceStoreCode) {
        this.serviceStoreCode = serviceStoreCode;
    }

    public String getServiceGuideCode() {
        return serviceGuideCode;
    }

    public void setServiceGuideCode(String serviceGuideCode) {
        this.serviceGuideCode = serviceGuideCode;
    }

    public String getErpId() {
        return erpId;
    }

    public void setErpId(String erpId) {
        this.erpId = erpId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getAllChannelIds() {
        return allChannelIds;
    }

    public void setAllChannelIds(String allChannelIds) {
        this.allChannelIds = allChannelIds;
    }

    public String getOpenCardTime() {
        return openCardTime;
    }

    public void setOpenCardTime(String openCardTime) {
        this.openCardTime = openCardTime;
    }

    public Integer getOpenCardChannelId() {
        return openCardChannelId;
    }

    public void setOpenCardChannelId(Integer openCardChannelId) {
        this.openCardChannelId = openCardChannelId;
    }

    public String getOpenCardChannelName() {
        return openCardChannelName;
    }

    public void setOpenCardChannelName(String openCardChannelName) {
        this.openCardChannelName = openCardChannelName;
    }

    public String getInviterCardNo() {
        return InviterCardNo;
    }

    public void setInviterCardNo(String inviterCardNo) {
        InviterCardNo = inviterCardNo;
    }

    public String getInviterName() {
        return InviterName;
    }

    public void setInviterName(String inviterName) {
        InviterName = inviterName;
    }

    public String getApplicationExternalId() {
        return applicationExternalId;
    }

    public void setApplicationExternalId(String applicationExternalId) {
        this.applicationExternalId = applicationExternalId;
    }
}
