package com.bizvane.connectorservice.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.UUID;

/**
 * UUID生成工具
 *
 * @author wangjiahao
 * @version 1.0
 * @className UUIDGenerator
 * @see UUID
 * @since 2018-12-18 10:22
 */
public class UUIDGenerator {
    //InetAddress ia1 = InetAddress.getLocalHost();//获取本地IP
	static Random random = new Random();
    private static int sequenceMax = 999999;
    private static int sequence = random.nextInt(sequenceMax);
	private static int length = 6;
	
	private static final String BASE = "fzxcvbnmkjhgdsaqwertyuipQWERTYUPASDFGHJKLZXCVBNM23456789";
	
	/**
	 * YYMMDDHHMMSS（12位）+6位自增
	 * @return获取带时间的唯一值（共18位）
	 */
	public static synchronized String getDatetime18() {
		sequence = sequence >= sequenceMax ? 1 : sequence + 1;
		String datetime = new SimpleDateFormat("yyMMddHHmmss").format(new Date());
		String s = Integer.toString(sequence);
		return datetime +addLeftZero(s, length);
	}
    /**
     * 获得Long类型的UUID
     *
     * @return UUID
     */
    public static Long getLongUuid() {
    	 return (long) Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", "1"));
    }

	public static Long getLongUuidNew() {
		return Long.parseLong(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", "1"));
	}

	//获取随机字符head+随机位数
	private static String getRandomByCodeString(String head,int length) {
		return head+getRandomString(length);
	}
	//获取随机字符
	private static String getRandomString(int length) {
		// 由Random生成随机数
		Random random = new Random();
		StringBuffer sb = new StringBuffer();
		// 长度为几就循环几次
		for (int i = 0; i < length; ++i) {
			// 产生0-61的数字
			int number = random.nextInt(BASE.length());
			// 将产生的数字通过length次承载到sb中
			sb.append(BASE.charAt(number));
		}
		// 将承载的字符转换成字符串
		return sb.toString();
	}
	
	/**
	 * YYYYMMDDHHMMSS(12位)
	 * @author shijing
	 * 2015年6月29日下午1:25:23
	 * @return
	 */
	public static String getIdBySeconds() {
		String datetime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
		return datetime ;
	}
	
	
	/**
	 * YYYYMMDDHH+4位(12位)
	 * @author shijing
	 * 2015年6月29日下午1:25:23
	 * @return
	 */
	public static String getId12Bytime() {
		String datetime = new SimpleDateFormat("MMddHHmm").format(new Date());
		return datetime+get4Uuid() ;
	}
	
	
	/**
	 * YYYYMMDDHHMMSS+6位自增长码(20位)
	 * @author shijing
	 * 2015年6月29日下午1:25:23
	 * @return
	 */
	public static synchronized String getLocalTrmSeqNum() {
		sequence = sequence >= 999999 ? 1 : sequence + 1;
		String datetime = new SimpleDateFormat("yyyyMMddHHmmss")
		.format(new Date());
		String s = Integer.toString(sequence);
		return datetime +addLeftZero(s, length);
	}
	

    /**
     * 获得4个长度的十六进制的UUID
     *
     * @return UUID
     */
    public static String get4Uuid() {
        UUID id = UUID.randomUUID();
        String[] idd = id.toString().split("-");
        return idd[1];
    }
    

    

    /**
     * 获得8个长度的十六进制的UUID
     *
     * @return UUID
     */
    public static String get8Uuid() {
        UUID id = UUID.randomUUID();
        String[] idd = id.toString().split("-");
        return idd[0];
    }

    /**
     * 获得12个长度的十六进制的UUID
     *
     * @return UUID
     */
    public static String get12Uuid() {
        UUID id = UUID.randomUUID();
        String[] idd = id.toString().split("-");
        return idd[0] + idd[1];
    }

    /**
     * 获得16个长度的十六进制的UUID
     *
     * @return UUID
     */
    public static String get16Uuid() {

        UUID id = UUID.randomUUID();
        String[] idd = id.toString().split("-");
        return idd[0] + idd[1] + idd[2];
    }

    /**
     * 获得20个长度的十六进制的UUID
     *
     * @return UUID
     */
    public static String get20Uuid() {

        UUID id = UUID.randomUUID();
        String[] idd = id.toString().split("-");
        return idd[0] + idd[1] + idd[2] + idd[3];
    }

    /**
     * 获得24个长度的十六进制的UUID
     *
     * @return UUID
     */
    public static String get24Uuid() {
        UUID id = UUID.randomUUID();
        String[] idd = id.toString().split("-");
        return idd[0] + idd[1] + idd[4];
    }

    /**
     * 获得32个长度的十六进制的UUID
     *
     * @return UUID
     */
    public static String get32Uuid() {
        UUID id = UUID.randomUUID();
        String[] idd = id.toString().split("-");
        return idd[0] + idd[1] + idd[2] + idd[3] + idd[4];
    }
    
	/**
	 * 左填0
	 * @author shijing
	 * 2015年6月29日下午1:24:32
	 * @param s
	 * @param length
	 * @return
	 */
	public static String addLeftZero(String s, int length) {
		// StringBuilder sb=new StringBuilder();
		int old = s.length();
		if (length > old) {
			char[] c = new char[length];
			char[] x = s.toCharArray();
			if (x.length > length) {
				throw new IllegalArgumentException(
						"Numeric value is larger than intended length: " + s
								+ " LEN " + length);
			}
			int lim = c.length - x.length;
			for (int i = 0; i < lim; i++) {
				c[i] = '0';
			}
			System.arraycopy(x, 0, c, lim, x.length);
			return new String(c);
		}
		return s.substring(0, length);
 

	}
}
