/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.connectorservice.util.httpclient;

import com.bizvane.connectorservice.util.httpclient.RestClientBuilder;
import com.bizvane.connectorservice.util.httpclient.RestClientBuilderBySap;
import com.bizvane.connectorservice.util.httpclient.RestClientException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestClient {
    public static final Object[] EMPTY_URI_VARIABLES = new Object[0];
    public static final HttpHeaders EMPTY_HEADERS = new HttpHeaders();
    public static final Map<String, ?> EMPTY_BODY = new HashMap(1);
    public static final HttpEntity EMPTY_ENTITY = new HttpEntity((MultiValueMap)EMPTY_HEADERS);

    public static <T> T exchange(String url, HttpMethod method, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return RestClient.exchange(url, method, null, null, responseType, uriVariables);
    }

    public static <T> T exchange(String url, HttpMethod method, HttpHeaders headers, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return RestClient.exchange(url, method, headers, null, responseType, uriVariables);
    }

    public static <T> T exchange(String url, HttpMethod method, Object body, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return RestClient.exchange(url, method, null, body, responseType, uriVariables);
    }

    public static <T> T exchange(String url, HttpMethod method, HttpHeaders httpHeaders, Object body, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        try {
            HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)httpHeaders);
            requestEntity = RestClient.convert(requestEntity);
            if (uriVariables.length == 1 && uriVariables[0] instanceof Map) {
                Map aUriVariables = (Map)uriVariables[0];
                return (T)RestClient.getClient().exchange(url, method, requestEntity, responseType, aUriVariables).getBody();
            }
            return (T)RestClient.getClient().exchange(url, method, requestEntity, responseType, uriVariables).getBody();
        }
        catch (Exception e) {
            throw new RestClientException(e);
        }
    }

    public static <T> T exchangeBy(String url, HttpMethod method, HttpHeaders httpHeaders, Object body, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        try {
            HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)httpHeaders);
            requestEntity = RestClient.convert(requestEntity);
            if (uriVariables.length == 1 && uriVariables[0] instanceof Map) {
                Map aUriVariables = (Map)uriVariables[0];
                return (T)RestClient.getClient().exchange(url, method, requestEntity, responseType, aUriVariables).getBody();
            }
            return (T)RestClient.getClientBySap().exchange(url, method, requestEntity, responseType, uriVariables).getBody();
        }
        catch (Exception e) {
            throw new RestClientException(e);
        }
    }

    public static <T> T exchange(String url, HttpMethod method, ParameterizedTypeReference<T> responseType, Object ... uriVariables) throws RestClientException {
        return RestClient.exchange(url, method, null, null, responseType, uriVariables);
    }

    public static <T> T exchange(String url, HttpMethod method, HttpHeaders headers, ParameterizedTypeReference<T> responseType, Object ... uriVariables) throws RestClientException {
        return RestClient.exchange(url, method, headers, null, responseType, uriVariables);
    }

    public static <T> T exchange(String url, HttpMethod method, Object body, ParameterizedTypeReference<T> responseType, Object ... uriVariables) throws RestClientException {
        return RestClient.exchange(url, method, null, body, responseType, uriVariables);
    }

    public static <T> T exchange(String url, HttpMethod method, HttpHeaders httpHeaders, Object body, ParameterizedTypeReference<T> responseType, Object ... uriVariables) throws RestClientException {
        try {
            HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)httpHeaders);
            requestEntity = RestClient.convert(requestEntity);
            if (uriVariables.length == 1 && uriVariables[0] instanceof Map) {
                Map aUriVariables = (Map)uriVariables[0];
                return (T)RestClient.getClient().exchange(url, method, requestEntity, responseType, aUriVariables).getBody();
            }
            return (T)RestClient.getClient().exchange(url, method, requestEntity, responseType, uriVariables).getBody();
        }
        catch (Exception e) {
            throw new RestClientException(e);
        }
    }

    public static RestTemplate getClient() {
        return RestClientBuilder.builder();
    }

    public static RestTemplate getClientBySap() {
        return RestClientBuilderBySap.builder();
    }

    public static HttpHeaders buildBasicFormHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return headers;
    }

    public static HttpHeaders buildBasicJsonHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    public static HttpHeaders buildBasicHtmlHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_HTML);
        return headers;
    }

    private static HttpEntity<?> convert(HttpEntity<?> requestEntity) {
        Object body = requestEntity.getBody();
        HttpHeaders headers = requestEntity.getHeaders();
        if (body == null) {
            return requestEntity;
        }
        if (body instanceof Map) {
            LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
            Map aBody = (Map)body;
            for (String key : aBody.keySet()) {
                multiValueMap.add((Object)key, (Object)MapUtils.getString((Map)aBody, (Object)key));
            }
            requestEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)headers);
        }
        if (headers == null || !MediaType.APPLICATION_FORM_URLENCODED.equals((Object)headers.getContentType())) {
            return requestEntity;
        }
        if (body instanceof String) {
            return requestEntity;
        }
        if (body instanceof Collection) {
            return requestEntity;
        }
        if (body instanceof Map) {
            return requestEntity;
        }
        LinkedMultiValueMap formEntity = new LinkedMultiValueMap();
        Field[] fields = body.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            String value = null;
            try {
                value = BeanUtils.getProperty((Object)body, (String)name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            formEntity.add((Object)name, (Object)value);
        }
        return new HttpEntity((Object)formEntity, (MultiValueMap)headers);
    }
}

