package com.bizvane.connectorservice.interfaces.rpc;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.zds.pos.*;
import com.bizvane.utils.responseinfo.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author zcc
 * @date 2022/10/18 15:17
 **/
@FeignClient(value = "${feign.client.connector.name}",path = "${feign.client.connector.path}/zdsPos")
public interface ZdsPosConnectorServiceFeign {

    /**
     * 查询销售业绩
     * @param requestVo
     * @return
     */
    @PostMapping("/getSalesRevenueByVo")
    Result<SalesRevenueResVo> getSalesRevenueByVo(@RequestBody SalesRevenueRequestVo requestVo);

    /**
     * 查询区域能力
     * @param requestVo
     * @return
     */
    @PostMapping("/getAreaDimensionByVo")
    Result<AreaDimensionResVo> getAreaDimensionByVo(@RequestBody AreaDimensionRequestVo requestVo);

    /**
     * 店铺列表销售业绩查询
     * @param requestVo
     * @return
     */
    @PostMapping("/getStoreRankRevenueByVo")
    Result<List<StoreRankRevenueResVo>> getStoreRankRevenueListByVo(@RequestBody StoreRankRequestVo requestVo);

    /**
     * 店铺列表会销比查询
     * @param requestVo
     * @return
     */
    @PostMapping("/getStoreRankMemberRateByVo")
    Result<List<StoreRankMemberRateResVo>> getStoreRankMemberRateListByVo(@RequestBody StoreRankRequestVo requestVo);

    /**
     * 店铺列表连带率查询
     * @param requestVo
     * @return
     */
    @PostMapping("/getStoreRankUptByVo")
    Result<List<StoreRankUptResVo>> getStoreRankUptListByVo(@RequestBody StoreRankRequestVo requestVo);

    /**
     * 员工列表销售业绩查询
     * @param requestVo
     * @return
     */
    @PostMapping("/getStaffRankRevenuePageByVo")
    Result<PageInfo<StaffRankRevenueResVo>> getStaffRankRevenuePageByVo(@RequestBody StaffRankRequestVo requestVo);

    /**
     * 员工列表会销比查询
     * @param requestVo
     * @return
     */
    @PostMapping("/getStaffRankMemberRatePageByVo")
    Result<PageInfo<StaffRankMemberRateResVo>> getStaffRankMemberRatePageByVo(@RequestBody StaffRankRequestVo requestVo);

    /**
     * 员工列表连带率查询
     * @param requestVo
     * @return
     */
    @PostMapping("/getStaffRankUptPageByVo")
    Result<PageInfo<StaffRankUptResVo>> getStaffRankUptPageByVo(@RequestBody StaffRankRequestVo requestVo);

    /**
     * 店铺业绩详情查询
     * @param requestVo
     * @return
     */
    @PostMapping("/getStoreRevenueDetailListByVo")
    Result<List<StoreRevenueDetailResVo>> getStoreRevenueDetailListByVo(@RequestBody StoreRevenueDetailRequestVo requestVo);

    /**
     * 个人能力数据查询
     * @param requestVo
     * @return
     */
    @PostMapping("/getPersonalAbilityByVo")
    Result<PersonalAbilityResVo> getPersonalAbilityByVo(@RequestBody PersonalAbilityRequestVo requestVo);

    /**
     * 个人业绩详情
     * @param requestVo
     * @return
     */
    @PostMapping("/getStaffRevenueDetailListByVo")
    Result<StaffRevenueDetailResVo> getStaffRevenueDetailListByVo(@RequestBody StaffRevenueDetailRequestVo requestVo);


    /**
     * 店铺详情-店铺业绩
     * @param requestVo
     * @return
     */
    @PostMapping("/getStoreDetailByVo")
    Result<StoreDetailResVo> getStoreDetailByVo(@RequestBody StoreDetailRequestVo requestVo);

}
