package com.bizvane.connectorservice.entity.base;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.UUID;

/**
 * @author liuying
 * @date 2018/8/16
 * @description
 */

public class BaseModel implements Serializable{
    @ApiModelProperty(
            value = "线上品牌id",
            name = "brandId",
            required = true,
            example = "1"
    )
    private Long brandId;

    @ApiModelProperty(
            value = "线下品牌code",
            name = "offlineBrandCode",
            example = "002"
    )
    private String offlineBrandCode;

    @ApiModelProperty(
            value = "全局uuid(查询线上线下日志使用)",
            name = "sessionTokenId",
            required = false,
            example = "688a0a5f-c1d1-4d27-8aa2-b52d56c18924"
    )
    private String sessionTokenId;

    @ApiModelProperty(
            value = "大类",
            name = "bigCategory",
            required = false,
            example = "可选"
    )
    private String bigCategory;

    @ApiModelProperty(
            value = "中类",
            name = "middleCategory",
            required = false,
            example = "可选"
    )
    private String middleCategory;


    @ApiModelProperty(
            value = "小类",
            name = "samllCategory",
            required = false,
            example = "可选"
    )
    private String smallCategory;

    @ApiModelProperty(
            value = "年份",
            name = "particularYear",
            required = false,
            example = "可选"
    )
    private String particularYear;

    @ApiModelProperty(
            value = "季节",
            name = "season",
            required = false,
            example = "可选"
    )
    private String season;

    @ApiModelProperty(
            value = "线下组织code",
            name = "offlineOrgCodes",
            required = false,
            example = ""
    )
    private String offlineOrgCodes;

    @ApiModelProperty(
            value = "商品购买件数限制",
            name = "goodsCondition",
            required = false,
            example = ""
    )
    private Integer goodsCondition;

    @ApiModelProperty(
            value = "可选线下组织code",
            name = "couponDefOrgOfflineCodes",
            required = false,
            example = ""
    )
    private String couponDefOrgOfflineCodes;

    public String getCouponDefOrgOfflineCodes() {
        return couponDefOrgOfflineCodes;
    }

    public void setCouponDefOrgOfflineCodes(String couponDefOrgOfflineCodes) {
        this.couponDefOrgOfflineCodes = couponDefOrgOfflineCodes;
    }

    public Integer getGoodsCondition() {
        return goodsCondition;
    }

    public void setGoodsCondition(Integer goodsCondition) {
        this.goodsCondition = goodsCondition;
    }

    public String getOfflineOrgCodes() {
        return offlineOrgCodes;
    }

    public void setOfflineOrgCodes(String offlineOrgCodes) {
        this.offlineOrgCodes = offlineOrgCodes;
    }

    public String getParticularYear() {
        return particularYear;
    }

    public void setParticularYear(String particularYear) {
        this.particularYear = particularYear;
    }

    public String getSeason() {
        return season;
    }

    public void setSeason(String season) {
        this.season = season;
    }

    public String getBigCategory() {
        return bigCategory;
    }

    public void setBigCategory(String bigCategory) {
        this.bigCategory = bigCategory;
    }

    public String getMiddleCategory() {
        return middleCategory;
    }

    public void setMiddleCategory(String middleCategory) {
        this.middleCategory = middleCategory;
    }

    public String getSmallCategory() {
        return smallCategory;
    }

    public void setSmallCategory(String smallCategory) {
        this.smallCategory = smallCategory;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getOfflineBrandCode() {
        return offlineBrandCode;
    }

    public void setOfflineBrandCode(String offlineBrandCode) {
        this.offlineBrandCode = offlineBrandCode;
    }

    public String getSessionTokenId() {
        return sessionTokenId;
    }

    public void setSessionTokenId(String sessionTokenId) {
        this.sessionTokenId = sessionTokenId;
    }
}
