package com.bizvane.connectorservice.interfaces.out;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.CouponBatchRequestVO;
import com.bizvane.connectorservice.entity.out.huairen.*;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

public interface HuaiRenService {

    /**
     * 新增订单
     *
     * @param requestVO
     * @return
     */
    Result<HuaiRenAddOrderResponseVO> addOrder(HuaiRenAddOrderRequestVO requestVO) throws Exception;

    /**
     * 获取库存数
     *
     * @param requestVO
     * @return
     */
    Result<List<HuaiRenGetStocksResponseVO.HuaiRenStockChildVO>> getStocks(HuaiRenGetStocksRequestVO requestVO) throws Exception;

    /**
     * 新增退单
     *
     * @param requestVO
     * @return
     */
    Result<HuaiRenRefundOrderResponseVO> refundOrder(HuaiRenRefundOrderRequestVO requestVO) throws Exception;

    /**
     * 实时查询预提数量
     *
     * @param requestVO
     * @return
     */
    Result<HuaiRenGetStorageNumResponseVO> getStorageNum(HuaiRenGetStorageNumRequestVO requestVO) throws Exception;


}
