package com.bizvane.connectorservice.util;

import org.json.JSONObject;
import org.slf4j.LoggerFactory;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/**
 * @author admin
 */
public class RestUtils {
    private static org.slf4j.Logger log = LoggerFactory.getLogger(RestUtils.class.getName());

    private static final int TIME_OUT = 8 * 1000;

    public final static String POST = "post";

    public final static Integer SUCCESS_STATUS = 200;

    public static String sendRequestBuff(String apiUrl, String params, String method) throws Exception {
        return sendRequestBuff(apiUrl, params, method, false);
    }


    public static String sendRequestBuff(String apiUrl, String params, String method, boolean keepAlive) throws Exception {
        return sendRequestBuff(apiUrl, params, null, method, keepAlive);
    }

    public static String sendRequestBuff(String url, String params, JSONObject head, String method, boolean keepAlive) throws Exception {
        if (head == null) {
            head = new JSONObject();
        }

        log.info("url->" + url);
        if (StringUtil.isNotNull(params)) {
            log.info("params :" + (params.length() > 3000 ? params.substring(0, 3000) : params));
        }
        method = StringUtil.valueOf(method, "POST");
        log.info("sendRequest_buff params:" + params);
        HttpURLConnection conn = (HttpURLConnection) new URL(url).openConnection();
        conn.setRequestMethod(method.toUpperCase());

        //设置头部信息
        String key = null;
        Iterator<String> headKeys = head.keys();
        while (headKeys.hasNext()) {
            key = headKeys.next();
            conn.setRequestProperty(key, head.optString(key));
        }
        if (keepAlive) {
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setConnectTimeout(60 * 1000);
        } else {
            conn.setConnectTimeout(TIME_OUT);
        }
        conn.setDoInput(true);
        if (POST.equalsIgnoreCase(method)) {
            //POST不能用缓存
            conn.setUseCaches(false);
        }
        if (StringUtil.isNotNull(params)) {
            conn.setDoOutput(true);
            conn.getOutputStream().write(params.getBytes("utf-8"));
        }
        conn.connect();
        log.info(toCustomString(conn.getHeaderFields()));
        if (conn.getResponseCode() != SUCCESS_STATUS) {
            log.error("server status->" + conn.getResponseCode());
            throw new Exception("请求url失败");
        }
        //获取返回值
        BufferedInputStream bis = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        bis = new BufferedInputStream(conn.getInputStream());
        for (int len = 0; (len = bis.read(buf)) != -1; ) {
            baos.write(buf, 0, len);
        }
        log.info("chareset:" + conn.getContentType());
        String charset = getChareset(conn.getContentType());
        String resultString = baos.toString(charset);
        conn.disconnect();
        log.info("RestUtils result-->" + resultString);
        return resultString;
    }

    public static String getChareset(String contentType) {
        int i = contentType == null ? -1 : contentType.indexOf("charset=");
        return i == -1 ? "UTF-8" : contentType.substring(i + 8);
    }

    private static String toCustomString(Map ht) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();

        Object key;
        Object v;
        for (Iterator it = ht.keySet().iterator(); it.hasNext(); ) {
            key = it.next();
            v = ht.get(key);
            if (v == null) {
                buf.append(key + ":=" + null + lineSeparator);
                break;
            }
            if (v instanceof Collection) {
                v = toString(((Collection) v).toArray());
            } else if (v.getClass().isArray()) {
                v = toString((Object[]) v);
            }
            buf.append(key + ":=" + v + lineSeparator);
        }
        return buf.toString();
    }

    public static String toString(Object[] s) {
        try {
            if (s == null || s.length == 0) {
                return "null";
            }
            if (s.length == 1) {
                return s[0] + "";
            }
            String ret = "";
            for (int i = 0; i < s.length - 1; i++) {
                if (s[i].getClass().isArray()) {
                    ret += toString((Object[]) s[i]) + ",";
                }
                ret += s[i] + ",";
            }
            ret += s[s.length - 1];
            return ret;
        } catch (Exception e) {
            e.printStackTrace();
            return "internal error";
        }
    }

}
