package com.bizvane.connectorservice.entity.common;

import com.bizvane.connectorservice.entity.base.BaseModel;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Author: xiao.shu
 * @Date: 2019/5/5 11:10
 * @Description:
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */
@Data
public class RechargeRecordRequestVO extends BaseModel {
    /**
     * 储值卡号（第一充值时，是无值的）
     */
    private String petCard;

    /**
     * 支付密码
     */
    private String paymentCode;

    /**
     * 会员线下卡号
     */
    private String offlineCardNo;
    /**
     * 充值金额
     */

    private Double rechargeMoney;

    /**
     * 赠送金额
     */
    private Double rewardMoney;

    /**
     * 奖励比例
     */
    private Double rewardProportion;
    /**
     * 流水号
     */
    private String serialNumber;

    /**
     * 微信OPENID
     */
    private String openId;

    /**
     * 微信用户unionid
     */
    private String unionId;
    /**
     * 线上卡号
     */
    private String vipNo;

    /**
     *微信支付凭证
     */
    private String payNumber;

    private String vipId;

    private Long sysCompanyId;

    /**
     * 会员姓名
     */
    private String vipName;

    /**
     * 微信充值流水号
     */
    private String wxSerialNumber;

    /**
     * 会员手机号
     */
    private String vipPhone;

    /**
     *
     * @return
     */
    private String memberCode;

    /**
     * 卡面code
     * @return
     */
    private String cardStyleCode;

    /**
     * 总余额
     */
    private Double Balance;

    /**
     * 有效期
     * @return
     */
    @DateTimeFormat( pattern="yyyy-MM-dd HH:mm:ss")
    private Date validDate;

    /**
     * 所属导购
     * */
    private String serviceStoreCode;

    /**
     * 所属门店
     * */
    private String serviceGuideCode;

    /**
     * 门店编号
     * */
    private String rechargeStoreCode;
    /**
     *商户订单号
     */
    private String OutTradeNo;

    /**
     * 红蜻蜓
     * 业务标识
     * （CS-正常储值业务/
     * GB-实体卡转电子卡业务）
     * */
    private String businessId;

    /**
     * 红蜻蜓
     * 实体卡卡号
     * */
    private String paymentCard;

    /**
     * 储值卡归属类型 1.品牌 2.运营
     */
    private Integer cardSourceType;

    /**
     * 商帆运营组织Code
     */
    private String organizationCode;

}
