package com.bizvane.connectorcouponservice.util;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.connectorcouponservice.entity.base.BaseModel;

/**
 * @author liuying
 * @date 2018/8/15
 * @description
 */
public class CastUtil {

    private final static String BRAND_ID = "brandId";

    /**
     * 获取参数中的品牌id
     * @param param 入参
     * @return 参数中的品牌id,如果没有传即为null
     */
    public static Long getBrandId(Object param){
        if(param instanceof BaseModel){
            BaseModel baseModel = (BaseModel) param;
            return baseModel.getBrandId();
        }else if(param instanceof JSONObject){
            return ((JSONObject) param).getLongValue(BRAND_ID);
        }else if(param instanceof String){
            JSONObject jsonObject = JSONObject.parseObject(param.toString());
            if(jsonObject == null){
                return null;
            }else{
                return jsonObject.getLongValue(BRAND_ID);
            }
        }
        return null;
    }

}
