package com.bizvane.connectorcouponservice.interfaces.online;

import com.bizvane.connectorcouponservice.entity.Result;
import com.bizvane.connectorcouponservice.entity.common.ConnectConfigVO;
import com.bizvane.connectorcouponservice.entity.po.ConnectConfig;

import java.util.List;

/**
 * @author liuying
 * @date 2018/8/9
 * @description
 */

public interface ConnectConfigService {

    /**
     * 从db中加载所有t_connect_config表数据进redis
     */
    void refreshRedisAll();

    /**
     * 查询品牌相关参数
     * @param onlineBrandId
     * @return
     */
    ConnectConfig queryByOnlineBrandId(Long onlineBrandId);

    /**
     * 新增企业
     * @param requestVO
     * @return
     */
    Result addConnectConfig(ConnectConfigVO requestVO);

    /**
     * 更新企业及相关配置项
     * @param requestVO
     * @return
     */
    Result updateConnectConfig(ConnectConfigVO requestVO);

    /**
     * 获取所有企业配置项
     * @return
     */
    List<ConnectConfig> getAllConnectConfigList();
}
