package com.bizvane.connectorcouponservice.entity.common;

import com.bizvane.connectorcouponservice.entity.base.BaseModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Author: liuying@bizvane.cn
 * @Date: 2019/3/12 10:23
 * @Version 1.0
 */
public class CouponBindRequestVO extends BaseModel {

    @ApiModelProperty(
            value = "券号",
            name = "couponCode",
            required = false,
            example = ""
    )
    private String couponCode;

    @ApiModelProperty(
            value = "会员线下id",
            name = "erpId",
            required = false,
            example = ""
    )
    private String erpId;

    @ApiModelProperty(
            value = "会员线下卡号",
            name = "offlineCardNo",
            required = false,
            example = ""
    )
    private String offlineCardNo;

    /**
     * 是否补发(1,是 ,0,否)
     */
    private Integer isReissue;

    public Integer getIsReissue() {
        return isReissue;
    }

    public void setIsReissue(Integer isReissue) {
        this.isReissue = isReissue;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getErpId() {
        return erpId;
    }

    public void setErpId(String erpId) {
        this.erpId = erpId;
    }

    public String getOfflineCardNo() {
        return offlineCardNo;
    }

    public void setOfflineCardNo(String offlineCardNo) {
        this.offlineCardNo = offlineCardNo;
    }
}
