/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.serviceImpl;

import com.bizvane.interfaces.BaseInterface;
import com.bizvane.util.jdbc.QueryEngine;
import com.bizvane.util.tools.ResultUtil;
import java.math.BigDecimal;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RefundRechargeRecordServiceImpl
implements BaseInterface {
    private Logger logger = LoggerFactory.getLogger(RefundRechargeRecordServiceImpl.class);

    @Override
    public String handle(String procedureName, String brand, String params) throws Exception {
        this.logger.info("refundRechargeRecord-----\u300bparams:" + params);
        JSONObject inObject = new JSONObject(params);
        Object result = null;
        String petCard = inObject.optString("petCard");
        String refundNo = inObject.optString("refundNo");
        String vipId = inObject.optString("vipId");
        String memberName = inObject.optString("memberName");
        String memberPhone = inObject.optString("memberPhone");
        BigDecimal amount = inObject.optBigDecimal("amount", new BigDecimal(0));
        BigDecimal giveAmount = inObject.optBigDecimal("giveAmount", new BigDecimal(0));
        String applyUser = inObject.optString("applyUser");
        String remark = inObject.optString("remark");
        String refundFlowable = inObject.optString("status");
        if (StringUtils.isEmpty((Object)petCard)) {
            this.logger.info("\u65b0\u589e\u9000\u6b3e\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u50a8\u84c4\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return ResultUtil.disposeResult((String)"-1", (String)"\u50a8\u84c4\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a!").toString();
        }
        if (StringUtils.isEmpty((Object)vipId)) {
            this.logger.info("\u65b0\u589e\u9000\u6b3e\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u4f1a\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
            return ResultUtil.disposeResult((String)"-1", (String)"\u4f1a\u5458ID\u4e0d\u80fd\u4e3a\u7a7a!").toString();
        }
        if ("".equals(amount.toString()) || "".equals(giveAmount.toString())) {
            this.logger.info("\u65b0\u589e\u9000\u6b3e\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ResultUtil.disposeResult((String)"-1", (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!").toString();
        }
        String isExistsSql = " select count(1) from recharge_card t where t.recharge_card_id = ?";
        int count = QueryEngine.queryCount((String)isExistsSql, (Object[])new Object[]{petCard});
        if (count < 1) {
            return ResultUtil.disposeResult((String)"-1", (String)"\u66f4\u65b0\u50a8\u503c\u5361\u72b6\u6001\u5931\u8d25\uff0c\u4e3a\u67e5\u8be2\u5230\u76f8\u5e94\u50a8\u503c\u5361\u8bb0\u5f55").toString();
        }
        String updateRecCardSql = " update recharge_card t set t.card_status = ?,t.t_bizmd = sysdate() where t.recharge_card_id = ? ";
        if ("0".equals(refundFlowable)) {
            QueryEngine.doUpdate((String)updateRecCardSql, (Object[])new Object[]{refundFlowable, petCard});
            return ResultUtil.disposeResult((String)"0", (String)"\u7533\u8bf7\u9000\u6b3e\u6d41\u7a0b\uff0c\u66f4\u65b0\u50a8\u84c4\u5361\u72b6\u6001\u4e0d\u53ef\u7528\u6210\u529f!").toString();
        }
        if ("1".equals(refundFlowable)) {
            QueryEngine.doUpdate((String)updateRecCardSql, (Object[])new Object[]{refundFlowable, petCard});
            return ResultUtil.disposeResult((String)"0", (String)"\u9a73\u56de\u9000\u6b3e\u6d41\u7a0b\uff0c\u66f4\u65b0\u50a8\u84c4\u5361\u72b6\u6001\u53ef\u7528\u6210\u529f!").toString();
        }
        StringBuffer insertNoSql = new StringBuffer();
        insertNoSql.append(" INSERT INTO recharge_card_refund ( ");
        insertNoSql.append(" REFUND_NO,VIP_ID,NAME_VIP,MOBILE_VIP,RECHARGE_CARD_ID, ");
        insertNoSql.append(" AMOUNT,GIVE_AMOUNT,APPLY_USER,REFUND_DATE,REMARKS, ");
        insertNoSql.append(" T_BIZCR,T_BIZMD,VALID) ");
        insertNoSql.append(" VALUES(?,?,?,?,?, ");
        insertNoSql.append(" ?,?,?,sysdate(),?, ");
        insertNoSql.append(" sysdate(),sysdate(),'1') ");
        int i = QueryEngine.doSave((String)insertNoSql.toString(), (Object[])new Object[]{refundNo, vipId, memberName, memberPhone, petCard, amount, giveAmount, applyUser, remark});
        String queryMoneySql = "select t.amount,t.give_amount from recharge_card t where t.recharge_card_id = ?";
        JSONObject content = QueryEngine.queryJSONObject((String)queryMoneySql, (Object[])new Object[]{petCard});
        if (content != null && content.length() != 0) {
            BigDecimal rechargeMoneyCount = content.optBigDecimal("amount", new BigDecimal(0));
            BigDecimal giveAmountCount = content.optBigDecimal("give_amount", new BigDecimal(0));
            this.logger.info("\u50a8\u503c\u5361\u539f\u672c\u91d1\u4f59\u989d\uff1a" + rechargeMoneyCount);
            this.logger.info("\u50a8\u503c\u5361\u539f\u8d60\u9001\u91d1\u989d\uff1a" + giveAmountCount);
            if (rechargeMoneyCount.compareTo(amount) == -1 || giveAmountCount.compareTo(giveAmount) == -1) {
                this.logger.info("\u50a8\u503c\u5361\u539f\u91d1\u989d\u5c0f\u4e8e\u9000\u6b3e\u91d1\u989d\uff0c\u65e0\u6cd5\u9000\u6b3e\uff01");
                return ResultUtil.disposeResult((String)"-1", (String)"\u50a8\u503c\u5361\u539f\u91d1\u989d\u5c0f\u4e8e\u9000\u6b3e\u91d1\u989d\uff0c\u65e0\u6cd5\u9000\u6b3e!").toString();
            }
            String updateMoneySql = "update recharge_card t set t.amount = '0',t.give_amount = '0',t.card_status = '1',t.t_bizmd = sysdate() where t.recharge_card_id = ? ";
            QueryEngine.doUpdate((String)updateMoneySql, (Object[])new Object[]{petCard});
            this.logger.info("\u50a8\u503c\u5361\u9000\u6b3e\u6210\u529f\uff0c\u50a8\u503c\u5361\u53f7\u4e3a\uff1a" + petCard);
        }
        if (i == 0) {
            return ResultUtil.disposeResult((String)"-1", (String)"\u65b0\u589e\u50a8\u503c\u5361\u9000\u6b3e\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25").toString();
        }
        return ResultUtil.disposeResult((String)"0", (String)"\u65b0\u589e\u50a8\u503c\u5361\u9000\u6b3e\u8bb0\u5f55\u4fe1\u606f\u6210\u529f").toString();
    }
}

