/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.serviceImpl;

import com.bizvane.interfaces.BaseInterface;
import com.bizvane.interfaces.CommonConstant;
import com.bizvane.util.DateUtils;
import com.bizvane.util.GenderUtil;
import com.bizvane.util.jdbc.QueryEngine;
import com.bizvane.util.tools.ResultUtil;
import com.bizvane.util.tools.StringUtil;
import java.nio.charset.Charset;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements BaseInterface {
    Logger logger = LoggerFactory.getLogger(LoginServiceImpl.class);

    @Override
    public String handle(String procedureName, String brand, String params) throws Exception {
        this.logger.info("Default Charset=" + Charset.defaultCharset());
        this.logger.info("file.encoding=" + System.getProperty("file.encoding"));
        this.logger.info("Default Charset=" + Charset.defaultCharset());
        String str = CommonConstant.errorContent;
        this.logger.info("login-----\u300bparams:" + params);
        JSONObject inObject = new JSONObject(params);
        String phone = inObject.optString("phone", "");
        if (StringUtil.isNull((Object)phone)) {
            this.logger.info("phone is null !");
            return ResultUtil.disposeResult((String)"-1", (String)"\u624b\u673a\u53f7\u4e0d\u5b58\u5728,\u8bf7\u8f93\u5165\u624b\u673a\u53f7").toString();
        }
        if (StringUtil.isNull((Object)brand)) {
            this.logger.info("brand is null !");
            return ResultUtil.disposeResult((String)"-1", (String)"\u54c1\u724c\u4e0d\u5b58\u5728,\u8bf7\u8f93\u5165\u624b\u673a\u53f7").toString();
        }
        JSONObject userByMobile = this.queryUserByMobile(phone);
        if (userByMobile == null) {
            this.logger.info("\u7ebf\u4e0b\u6ca1\u6709\u4f1a\u5458,\u9700\u8981\u91cd\u65b0\u5f00\u5361:phone" + phone);
            return ResultUtil.disposeResult((String)"8888", (String)"\u7ebf\u4e0b\u6ca1\u6709\u4f1a\u5458,\u9700\u8981\u91cd\u65b0\u5f00\u5361").toString();
        }
        JSONObject resultParam = this.transferResultJSON(inObject, userByMobile);
        return ResultUtil.disposeResult((String)"0", (String)"\u7ebf\u4e0b\u7ed1\u5361\u6210\u529f!", (JSONObject)resultParam).toString();
    }

    public JSONObject transferResultJSON(JSONObject inObject, JSONObject userByMobile) {
        JSONObject resultParam = new JSONObject();
        resultParam.put("openid", (Object)inObject.optString("openid", ""));
        resultParam.put("levelCode", (Object)userByMobile.optString("vip_type_code", ""));
        resultParam.put("offlineCardNo", (Object)userByMobile.optString("card_no_vip", ""));
        resultParam.put("countIntegral", (Object)userByMobile.optString("points", ""));
        resultParam.put("name", (Object)userByMobile.optString("name_vip", ""));
        resultParam.put("birthday", (Object)DateUtils.transferDate(userByMobile.optString("t_vb", "")));
        resultParam.put("gender", (Object)GenderUtil.transferGenderToOnline(userByMobile.optString("sex_vip", "2")));
        resultParam.put("province", (Object)userByMobile.optString("PROVICE", ""));
        resultParam.put("city", (Object)userByMobile.optString("CITY", ""));
        resultParam.put("county", (Object)userByMobile.optString("DISTRICT", ""));
        resultParam.put("address", (Object)userByMobile.optString("ADDRESS", ""));
        resultParam.put("openStoreCode", (Object)userByMobile.optString("store_id", ""));
        resultParam.put("openGuideCode", (Object)userByMobile.optString("emp_id", ""));
        resultParam.put("erpId", (Object)userByMobile.optString("vip_id", ""));
        resultParam.put("openCardTime", (Object)userByMobile.optString("t_cr", ""));
        return resultParam;
    }

    public JSONObject queryUserByMobile(String phone) {
        String userConditionMobileSql = "SELECT\n\tvip_id,\n\tname_vip,\n\tcard_no_vip,\n\tmobile_vip,\n\tPROVICE,\n\tCITY,\n\tDISTRICT,\n\tADDRESS,\n\tt_vb,\n\tsex_vip,\n\tstore_id,\n\temp_id,\n\tvip_type_code,\n\tcard_type_id,\n\tvip_type_id,\n\tpoints,\n\tfr_active,\n\topen_status,\n\tis_sharebir,\n\tt_cr,\n\tt_md,\n\tt_dl\nFROM\n\tc_client_vip c\nWHERE\n\tc.MOBILE_VIP = ?";
        return QueryEngine.queryJSONObject((String)userConditionMobileSql, (Object[])new Object[]{phone});
    }
}

