/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.serviceImpl;

import com.bizvane.interfaces.BaseInterface;
import com.bizvane.util.jdbc.QueryEngine;
import com.bizvane.util.tools.ResultUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DebitCardConsumeRecordServiceImpl
implements BaseInterface {
    private Logger logger = LoggerFactory.getLogger(DebitCardConsumeRecordServiceImpl.class);

    @Override
    public String handle(String procedureName, String brand, String params) throws Exception {
        String updateMoneySql;
        int update;
        String INSERT_CONSUME_RECORD;
        int i;
        this.logger.info("debitCardConsume-----\u300bparams:" + params);
        JSONObject inObject = new JSONObject(params);
        String debitCardNo = inObject.optString("debitCardNo");
        String orderNo = inObject.optString("orderNo");
        String orderTime = inObject.optString("orderTime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String orderTimeDate = sdf.format(new Date(Long.parseLong(String.valueOf(orderTime))));
        int type = inObject.optInt("type");
        BigDecimal changeAmount = inObject.optBigDecimal("changeAmount", new BigDecimal(0));
        BigDecimal changeGiveAmount = inObject.optBigDecimal("changeGiveAmount", new BigDecimal(0));
        String flagInterface = inObject.optString("flagInterface", "");
        if (StringUtils.isEmpty((Object)debitCardNo)) {
            this.logger.info("\u65b0\u589e\u6d88\u8d39\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u50a8\u84c4\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return ResultUtil.disposeResult((String)"-1", (String)"\u50a8\u84c4\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a!").toString();
        }
        String isOrderExistsSql = " select count(1) from recharge_card_consume where order_no = ?";
        int countOrder = QueryEngine.queryCount((String)isOrderExistsSql, (Object[])new Object[]{orderNo});
        if (countOrder > 0) {
            return ResultUtil.disposeResult((String)"0", (String)"\u6d88\u8d39\u8bb0\u5f55\u5df2\u7ecf\u5b58\u5728").toString();
        }
        String isExistsSql = " select count(1) from recharge_card t where t.recharge_card_id = ?";
        int count = QueryEngine.queryCount((String)isExistsSql, (Object[])new Object[]{debitCardNo});
        if (count < 1) {
            return ResultUtil.disposeResult((String)"-1", (String)"\u672a\u67e5\u8be2\u5230\u8be5\u50a8\u84c4\u5361,\u65b0\u589e\u6d88\u8d39\u8bb0\u5f55\u5931\u8d25").toString();
        }
        String queryMoneySql = "select t.amount,t.give_amount from recharge_card t where t.recharge_card_id = ?";
        JSONObject content = QueryEngine.queryJSONObject((String)queryMoneySql, (Object[])new Object[]{debitCardNo});
        BigDecimal rechargeMoneySum = new BigDecimal(0);
        BigDecimal giveAmountSum = new BigDecimal(0);
        if (content != null && content.length() != 0) {
            BigDecimal rechargeMoneyCount = content.optBigDecimal("amount", new BigDecimal(0));
            this.logger.info("\u50a8\u503c\u5361\u539f\u672c\u91d1\u4f59\u989d\uff1a" + rechargeMoneyCount);
            BigDecimal giveAmountCount = content.optBigDecimal("give_amount", new BigDecimal(0));
            this.logger.info("\u50a8\u503c\u5361\u539f\u8d60\u9001\u91d1\u989d\uff1a" + giveAmountCount);
            if (type == 4) {
                if (!"".equals(flagInterface) && "adjustRechargeCard".equals(flagInterface)) {
                    this.logger.info("\u50a8\u503c\u5361\u4f59\u989d\u8c03\u6574\u63a5\u53e3\u4e0d\u6821\u9a8c\uff0c\u73b0\u6709\u91d1\u989d:{},\u6d88\u8d39\u91d1\u989d:{}\uff0c\u53ef\u4ee5\u6263\u6210\u8d1f\u6570", (Object)rechargeMoneyCount, (Object)changeAmount);
                } else if (rechargeMoneyCount.compareTo(changeAmount) == -1) {
                    this.logger.info("\u73b0\u6709\u91d1\u989d\u5c0f\u4e8e\u6d88\u8d39\u91d1\u989d\uff0c\u73b0\u6709\u91d1\u989d:{},\u6d88\u8d39\u91d1\u989d:{}", (Object)rechargeMoneyCount, (Object)changeAmount);
                    return ResultUtil.disposeResult((String)"-1", (String)"\u73b0\u6709\u91d1\u989d\u5c0f\u4e8e\u6d88\u8d39\u91d1\u989d").toString();
                }
                rechargeMoneySum = rechargeMoneyCount.subtract(changeAmount);
                giveAmountSum = giveAmountCount.subtract(changeGiveAmount);
            } else {
                rechargeMoneySum = rechargeMoneyCount.add(changeAmount);
                giveAmountSum = giveAmountCount.add(changeGiveAmount);
            }
        }
        if ((i = QueryEngine.doSave((String)(INSERT_CONSUME_RECORD = "insert into  recharge_card_consume (ORDER_NO,TYPE,RECHARGE_CARD_ID,AMOUNT,GIVE_AMOUNT,CONSUME_DATE,T_BIZCR,T_BIZMD,VALID,CURRENT_AMOUNT,CURRNENT_GIVE_AMOUNT,ORDER_TIME) values (?,?,?,?,?,sysdate(),sysdate(),sysdate(),?,?,?,?)").toString(), (Object[])new Object[]{orderNo, type, debitCardNo, changeAmount, changeGiveAmount, 1, rechargeMoneySum, giveAmountSum, orderTimeDate})) > 0) {
            this.logger.info("\u63d2\u5165\u5230recharge_card_consume \u6210\u529f");
        }
        if ((update = QueryEngine.doUpdate((String)(updateMoneySql = "update recharge_card t set t.amount = ?,t.give_amount = ?,t.t_bizmd = sysdate() where t.recharge_card_id = ? "), (Object[])new Object[]{rechargeMoneySum, giveAmountSum, debitCardNo})) > 0) {
            this.logger.info("\u66f4\u65b0 recharge_card \u6210\u529f\uff0c\u50a8\u503c\u5361\u53f7\u4e3a:{},\u5f53\u524d\u672c\u91d1\u91d1\u989d:{},\u5f53\u524d\u8d60\u9001\u91d1\u989d\u4f59\u989d:{}", new Object[]{debitCardNo, rechargeMoneySum, giveAmountSum});
            return ResultUtil.disposeResult((String)"0", (String)"\u65b0\u589e\u6d88\u8d39\u8bb0\u5f55\u6210\u529f").toString();
        }
        return ResultUtil.disposeResult((String)"-1", (String)"\u65b0\u589e\u6d88\u8d39\u8bb0\u5f55\u5931\u8d25").toString();
    }
}

