package com.bizvane.utils.enumutils;


public enum SysThirdChannelEnum {

    ALIPAY_CHANNEL("alipay", "支付宝"),
    BIZVANEMALL_CHANNEL("bizMall", "商帆微商城"),
    WMMALL_CHANNEL("weimob", "微盟渠道"),
    OPENAPI_CHANNEL("openapi", "开放平台"),
    OTHER_CHANNEL("other", "其他");

    private String typeCode;

    private String typeName;

    SysThirdChannelEnum(String typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public static SysThirdChannelEnum getSysThirdChannelEnumByCode(String typeCode){
        for(SysThirdChannelEnum sysThirdChannelEnum : SysThirdChannelEnum.values()){
            if (typeCode == sysThirdChannelEnum.getTypeCode()) {
                return sysThirdChannelEnum;
            }
        }
        return OTHER_CHANNEL;
    }
}
