/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.redisutils;

import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"spring.redis.host"})
@Component
public class DistributedLock {
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;

    public boolean acquireLock(String lockKey, long expireTime) {
        return this.setIfAbsent(lockKey, expireTime, 100L);
    }

    public void releaseLock(String lockKey) {
        this.redisTemplate.delete((Object)lockKey);
    }

    private boolean setIfAbsent(String lockKey, long expireTime, long sleepTime) {
        if (expireTime <= 0L) {
            return false;
        }
        ValueOperations ops = this.redisTemplate.opsForValue();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            if (Boolean.TRUE.equals(ops.setIfAbsent((Object)lockKey, (Object)"1", expireTime, TimeUnit.MILLISECONDS))) {
                return true;
            }
            if (System.currentTimeMillis() - startTime >= expireTime) {
                return false;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            sleepTime = Math.min(sleepTime + 100L, 1000L);
        }
        return false;
    }
}

