/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.thread;

import com.bizvane.utils.thread.ThreadConfig;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class AsyncTaskExecutePool
implements AsyncConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(AsyncTaskExecutePool.class);
    @Autowired
    private ThreadConfig config;

    public Executor getAsyncExecutor() {
        logger.info("\u914d\u7f6e\u7ebf\u7a0b\u6c60");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.config.getCorePoolSize());
        executor.setMaxPoolSize(this.config.getMaxPoolSize());
        executor.setQueueCapacity(this.config.getQueueCapacity());
        executor.setKeepAliveSeconds(this.config.getKeepAliveSeconds());
        executor.setThreadNamePrefix(this.config.getThreadNamePrefix());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new AsyncUncaughtExceptionHandler(this){

            public void handleUncaughtException(Throwable arg0, Method arg1, Object ... arg2) {
                logger.error("==========================" + arg0.getMessage() + "=======================", arg0);
                logger.error("exception method:" + arg1.getName());
            }
        };
    }
}

