package com.bizvane.utils.rocketutils;

import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.PropertyKeyConst;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.Properties;

/**
 * 消息生产者
 */
@Configuration
public class RocketMQProvider extends RocketMQBean {

    @PostConstruct
    public Producer init() {
        if (this.validation()) {
            return null;
        }
        // producer 实例配置初始化
        Properties properties = new Properties();
        //控制台创建的Producer ID
        if (StringUtils.isNotBlank(producerId)) {
            properties.setProperty(PropertyKeyConst.ProducerId, producerId);
        }
        // AccessKey 阿里云身份验证，在阿里云服务器管理控制台创建
        properties.setProperty(PropertyKeyConst.AccessKey, accessKey);
        // SecretKey 阿里云身份验证，在阿里云服务器管理控制台创建
        properties.setProperty(PropertyKeyConst.SecretKey, secretKey);
        //设置发送超时时间，单位毫
        //properties.setProperty(PropertyKeyConst.SendMsgTimeoutMillis, timeOut);
        // 设置 TCP 接入域名（公共云生产环境）
        properties.setProperty(ONSAddr, namesrvAddr);

        producer = ONSFactory.createProducer(properties);
        // 在发送消息前，必须调用start方法来启动Producer，只需调用一次即可
        producer.start();
        return producer;
    }

    private static Producer producer;


    @Bean("producer")
    public Producer getProducer() {
        return producer;
    }


}
