package com.bizvane.utils.rocketutils;


import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/**
 * Created by Administrator on 2018\7\24 0024.
 */
@Component
public class RocketMQClient {

    @Autowired
    public ApplicationContext context;

    /**
     * by message send
     *
     * @param message
     * @return
     */
    public SendResult sendMessage(Message message) {
        Producer producer = (Producer) context.getBean("producer");
        SendResult sendResult = producer.send(message);
        return sendResult;
    }

    /**
     * by messageBody topic tag megID messageKey send
     *
     * @param messageBody
     * @param topic
     * @param tag
     * @param megID
     * @param messageKey
     * @return
     */
    public SendResult sendMessage(String messageBody, String topic, String tag, String megID, String messageKey) {
        Producer producer = (Producer) context.getBean("producer");
        Message message = new Message();
        message.setMsgID(megID);
        //messageKey 是用来做消息幂等性的处理
        message.setKey(messageKey);
        message.setTag(tag);
        message.setTopic(topic);
        message.setBody(messageBody.getBytes());
        SendResult sendResult = producer.send(message);
        return sendResult;
    }


    /**
     * by messageBody topic tag  send
     *
     * @param messageBody
     * @param topic
     * @param tag
     * @return
     */
    public SendResult sendMessage(String messageBody, String topic, String tag) {
        Producer producer = (Producer) context.getBean("producer");
        Message message = new Message();
        message.setTag(tag);
        message.setTopic(topic);
        message.setBody(messageBody.getBytes());
        SendResult sendResult = producer.send(message);
        return sendResult;
    }


    /**
     * send deliver time message
     * 定时消息，单位毫秒（ms），在指定时间戳（当前时间之后）进行投递，例如 2016-03-07 16:21:00 投递
     *
     * @param messageBody
     * @param topic
     * @param tag
     * @return
     */
    public SendResult sendDeliverTimeMessage(String messageBody, String topic, String tag, long timeStamp) {
        Producer producer = (Producer) context.getBean("producer");
        Message message = new Message();
        message.setTag(tag);
        message.setTopic(topic);
        message.setBody(messageBody.getBytes());
        message.setStartDeliverTime(timeStamp);
        SendResult sendResult = producer.send(message);
        return sendResult;
    }


    /**
     * 延时消息，单位毫秒（ms），在指定延迟时间（当前时间之后）进行投递，例如消息在 3 秒后投递
     *
     * @param messageBody
     * @param topic
     * @param tag
     * @param timeStamp
     * @return
     */
    public SendResult sendDelayMessage(String messageBody, String topic, String tag, long timeStamp) {
        Producer producer = (Producer) context.getBean("producer");
        long delayTime = System.currentTimeMillis() + timeStamp;
        Message message = new Message();
        message.setTag(tag);
        message.setTopic(topic);
        message.setBody(messageBody.getBytes());
        message.setStartDeliverTime(delayTime);
        SendResult sendResult = producer.send(message);
        return sendResult;
    }
}
