/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.config;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackSensitiveDataFilter
extends Filter<ILoggingEvent> {
    private Level level;
    private static final Pattern PHONE_PATTERN = Pattern.compile("([\\\\\"']{0,3}phone[\\\\\"']{0,3}\\s*[:=]\\s*[\\\\\"']{0,3})(\\d{3})\\d{4}(\\d{4})([\\\\\"']{0,3})");

    public FilterReply decide(ILoggingEvent event) {
        String message = event.getFormattedMessage();
        Matcher matcher = PHONE_PATTERN.matcher(message);
        if (matcher.find()) {
            String sanitizedMessage = matcher.replaceAll("$1$2****$3$4");
            this.logSanitizedMessage(event, sanitizedMessage);
            return FilterReply.DENY;
        }
        return FilterReply.NEUTRAL;
    }

    private void logSanitizedMessage(ILoggingEvent event, String sanitizedMessage) {
        Logger logger = LoggerFactory.getLogger((String)event.getLoggerName());
        switch (event.getLevel().levelInt) {
            case 40000: {
                logger.error(sanitizedMessage);
                break;
            }
            case 30000: {
                logger.warn(sanitizedMessage);
                break;
            }
            case 20000: {
                logger.info(sanitizedMessage);
                break;
            }
            case 10000: {
                logger.debug(sanitizedMessage);
                break;
            }
            case 5000: {
                logger.trace(sanitizedMessage);
                break;
            }
            default: {
                logger.info(sanitizedMessage);
            }
        }
    }

    public void setLevel(String level) {
        this.level = Level.toLevel((String)level);
    }

    public void start() {
        if (this.level != null) {
            super.start();
        }
    }
}

