/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.sm;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.crypto.digests.SM3Digest;

public class SM3Utils {
    public static String generateKeyHex(String deviceId) {
        try {
            byte[] deviceIdBytes = deviceId.getBytes(StandardCharsets.UTF_8);
            SM3Digest sm3Digest = new SM3Digest();
            sm3Digest.update(deviceIdBytes, 0, deviceIdBytes.length);
            byte[] hash = new byte[sm3Digest.getDigestSize()];
            sm3Digest.doFinal(hash, 0);
            byte[] sm4KeyBytes = new byte[16];
            System.arraycopy(hash, 0, sm4KeyBytes, 0, 16);
            return SM3Utils.byteArrayToHex(sm4KeyBytes);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u57fa\u4e8edeviceId\u751f\u6210\u52a0\u5bc6\u5bc6\u94a5\u5f02\u5e38\uff0cdeviceId:%s", deviceId), e);
        }
    }

    public static String byteArrayToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

