/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.crypto.advice;

import com.bizvane.crypto.annotation.ResponseEncryptField;
import com.bizvane.utils.sm.SM3Utils;
import com.bizvane.utils.sm.SM4Utils;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseEncryptAdvice
implements ResponseBodyAdvice<Object> {
    @Value(value="${spring.crypto.header-key:deviceId}")
    private String cryptoKey;
    @Resource
    private HttpServletRequest request;
    private final Set<Object> processedObjects = new HashSet<Object>();

    @PostConstruct
    public void init() {
        System.out.println("ResponseEncryptAdvice inited.");
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest serverHttpRequest, ServerHttpResponse response) {
        if (body == null) {
            return null;
        }
        String deviceId = this.request.getHeader(this.cryptoKey);
        if (deviceId == null || deviceId.trim().isEmpty()) {
            return body;
        }
        String keyHex = SM3Utils.generateKeyHex(deviceId);
        this.processFields(body, keyHex);
        return body;
    }

    private void processFields(Object object, String keyHex) {
        Field[] fields;
        if (object == null || this.processedObjects.contains(object)) {
            return;
        }
        this.processedObjects.add(object);
        Class<?> clazz = object.getClass();
        if (this.isSimpleValueType(clazz)) {
            return;
        }
        if (object instanceof Collection) {
            for (Object item : (Collection)object) {
                this.processFields(item, keyHex);
            }
            return;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object value = field.get(object);
                ResponseEncryptField annotation = field.getAnnotation(ResponseEncryptField.class);
                if (annotation != null && value instanceof String && !StringUtils.isEmpty((Object)value)) {
                    String text = SM4Utils.encryptSM4((String)value, keyHex);
                    field.set(object, text);
                }
                this.processFields(value, keyHex);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("\u5904\u7406\u5b57\u6bb5%s\u7684\u52a0\u5bc6\u5931\u8d25", field.getName()), e);
            }
        }
    }

    private boolean isSimpleValueType(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.equals(String.class) || Date.class.isAssignableFrom(clazz) || LocalDateTime.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz);
    }
}

