package com.bizvane.utils.cache.guava;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import java.util.Map;

@ConditionalOnProperty(name = "cache.guava.maximumSize")
@Component
public class GuavaContext <T> {

    @Autowired
    private Map<String, GuavaBizService<T>> typeMap;


    public GuavaBizService<T> getType(String code) {

        return typeMap.get(code);
    }
}
