package com.bizvane.utils.redisutils;

import java.io.Serializable;

import org.redisson.api.RedissonClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * wang.zeyan
 */
@Configuration
@AutoConfigureAfter({org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration.class})
public class RedisAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public RedisClient redisClient(RedisTemplate<Serializable, Object> redisTemplate) {
        return new RedisClient(redisTemplate);
    }

    @ConditionalOnBean(RedissonClient.class)
    @ConditionalOnMissingBean
    @Bean
    public RedissonTemplate redissonTemplate(RedissonClient redissonClient){
        return new RedissonTemplate(redissonClient);
    }

    @Bean("redisTemplateService")
    @ConditionalOnMissingBean
    public RedisTemplateService<Serializable, Object> redisTemplateService(RedisTemplate<Serializable, Object> redisTemplate){
        return new RedisTemplateServiceImpl<Serializable, Object>(redisTemplate);
    }
}
