/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.responseinfo;

import com.github.pagehelper.Page;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

@ApiModel(value="\u6570\u636e\u9875\u4fe1\u606f")
public class PageInfo<T>
implements Serializable {
    private static final long serialVersionUID = 8656597559014685635L;
    private List<T> list;
    private int pageNum = 0;
    private int pageSize = 10;
    private long total = 0L;
    private int pages = 0;
    private int size = 0;

    public PageInfo(List<T> list, int pageNum, int pageSize, long total, int pages, int size) {
        this.list = list;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.total = total;
        this.pages = pages;
        this.size = size;
    }

    public PageInfo() {
    }

    @ApiModelProperty(value="\u603b\u9875\u6570")
    public int getPages() {
        if (this.pages > 0) {
            return this.pages;
        }
        if (this.total > 0L) {
            return (int)((this.total + (long)this.pageSize - 1L) / (long)this.pageSize);
        }
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    @ApiModelProperty(value="\u5f53\u524d\u9875\u6570\u636e\u6570")
    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public PageInfo(int pageNum, int pageSize) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public PageInfo(List<T> list) {
        this.list = list;
        this.total = list instanceof Page ? ((Page)list).getTotal() : (long)list.size();
        if (list instanceof Page) {
            Page page = (Page)list;
            this.pageNum = page.getPageNum();
            this.pageSize = page.getPageSize();
            this.pages = page.getPages();
            this.size = page.size();
        } else if (list instanceof Collection) {
            this.pageNum = 1;
            this.pageSize = list.size();
            this.pages = this.pageSize > 0 ? 1 : 0;
            this.size = list.size();
        }
    }

    @ApiModelProperty(value="\u6570\u636e\u5217\u8868")
    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    @ApiModelProperty(value="\u9875\u7d22\u5f15")
    public int getPageNum() {
        return this.pageNum;
    }

    public void setPage(int pageNum) {
        this.pageNum = pageNum;
    }

    @ApiModelProperty(value="\u6bcf\u9875\u51e0\u6761\u6570\u636e")
    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @ApiModelProperty(value="\u603b\u8bb0\u5f55\u6570")
    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }
}

