/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.channelsmallshop.mq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.bizvane.channelsmallshop.service.constants.SystemConstants;
import com.bizvane.channelsmallshop.service.entity.po.ChannelsComponentAuthPO;
import com.bizvane.channelsmallshop.service.entity.po.ChannelsComponentAuthPOExample;
import com.bizvane.channelsmallshop.service.entity.po.ChannelsComponentAuthorizerAuthPO;
import com.bizvane.channelsmallshop.service.entity.po.ChannelsSmallShopInfoPO;
import com.bizvane.channelsmallshop.service.entity.po.ChannelsWxServiceComponentPO;
import com.bizvane.channelsmallshop.service.entity.po.ChannelsWxServiceComponentPOExample;
import com.bizvane.channelsmallshop.service.entity.po.ChannelsWxServicePlatformAuthPO;
import com.bizvane.channelsmallshop.service.entity.po.ChannelsWxServicePlatformAuthPOExample;
import com.bizvane.channelsmallshop.service.interfaces.WeChatService;
import com.bizvane.channelsmallshop.service.mapper.ChannelsComponentAuthPOMapper;
import com.bizvane.channelsmallshop.service.mapper.ChannelsComponentAuthorizerAuthPOMapper;
import com.bizvane.channelsmallshop.service.mapper.ChannelsSmallShopInfoPOMapper;
import com.bizvane.channelsmallshop.service.mapper.ChannelsWxServiceComponentPOMapper;
import com.bizvane.channelsmallshop.service.mapper.ChannelsWxServicePlatformAuthPOMapper;
import com.bizvane.channelsmallshop.service.utils.WechatTools;
import com.bizvane.channelsmallshop.service.utils.msgcrypt.AesException;
import com.bizvane.channelsmallshop.service.utils.msgcrypt.WXBizMsgCrypt;
import com.bizvane.channelsmallshop.service.utils.msgcrypt.XMLParse;
import com.bizvane.channelsmallshop.service.vo.wechat.ApiGetAuthorizerInfoResultVO;
import com.bizvane.channelsmallshop.service.vo.wechat.GetChannelsBasicsInfoResultVO;
import com.bizvane.channelsmallshop.service.vo.wechat.GetServiceBuyerExpireTimeResultVO;
import com.bizvane.channelsmallshop.service.vo.wechat.WechatBaseRequestVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import java.sql.Date;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import jodd.time.TimeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RocketMQMessageListener(topic="channel_wx_topic", tags={"channel_wechat_service_market_tag"})
public class WechatServiceMarketConsumer
implements RocketMQListener<WechatBaseRequestVO> {
    private static final Logger log = LoggerFactory.getLogger(WechatServiceMarketConsumer.class);
    @Autowired
    private ChannelsWxServicePlatformAuthPOMapper wxServicePlatformAuthPOMapper;
    @Autowired
    private ChannelsWxServiceComponentPOMapper channelsWxServiceComponentPOMapper;
    @Autowired
    private ChannelsComponentAuthPOMapper channelsComponentAuthPOMapper;
    @Autowired
    private ChannelsSmallShopInfoPOMapper channelsSmallShopInfoPOMapper;
    @Autowired
    private ChannelsComponentAuthorizerAuthPOMapper channelsComponentAuthorizerAuthPOMapper;
    @Autowired
    private WeChatService weChatService;

    public void onMessage(ConsumerMessage<WechatBaseRequestVO> consumerMessage) {
        log.info("WechatServiceMarketConsumer consumerMessage: {}", (Object)JacksonUtil.bean2Json(consumerMessage));
        WechatBaseRequestVO message = (WechatBaseRequestVO)consumerMessage.getMessage();
        String postData = message.getPostData();
        String nonce = message.getNonce();
        String timestamp = message.getTimestamp();
        String msgSignature = message.getMsg_signature();
        Object[] encrypt = new Object[]{};
        try {
            encrypt = XMLParse.extract((String)postData);
        }
        catch (AesException e) {
            log.info("WechatComponentVerifyTicketConsumer extract exception: {}", (Throwable)e);
            return;
        }
        String appId = String.valueOf(encrypt[0]);
        ChannelsWxServicePlatformAuthPOExample wxServicePlatformAuthPOExample = new ChannelsWxServicePlatformAuthPOExample();
        wxServicePlatformAuthPOExample.createCriteria().andPlatformAppIdEqualTo(appId).andValidEqualTo(Integer.valueOf(1));
        List channelsWxServicePlatformAuthPOS = this.wxServicePlatformAuthPOMapper.selectByExample(wxServicePlatformAuthPOExample);
        log.info("channelsWxServicePlatformAuthPOS: {}", (Object)JacksonUtil.list2Json((List)channelsWxServicePlatformAuthPOS));
        if (CollectionUtils.isEmpty((Collection)channelsWxServicePlatformAuthPOS)) {
            return;
        }
        ChannelsWxServicePlatformAuthPO channelsWxServicePlatformAuthPO = (ChannelsWxServicePlatformAuthPO)channelsWxServicePlatformAuthPOS.get(0);
        String token = channelsWxServicePlatformAuthPO.getToken();
        String encodingAeskey = channelsWxServicePlatformAuthPO.getEncodingAeskey();
        String decryptMsg = null;
        try {
            WXBizMsgCrypt wxBizMsgCrypt = new WXBizMsgCrypt(token, encodingAeskey, appId);
            decryptMsg = wxBizMsgCrypt.decryptMsg(msgSignature, timestamp, nonce, postData);
        }
        catch (AesException e) {
            log.info("WechatComponentVerifyTicketConsumer decryptMsg exception: {}", (Throwable)e);
            return;
        }
        log.info("WechatComponentVerifyTicketConsumer decryptMsg: {}", (Object)decryptMsg);
        Map postMap = WechatTools.getPostMap((String)decryptMsg);
        String serviceId = (String)postMap.get("serviceId");
        String authAppid = (String)postMap.get("appid");
        Long sysBrandId = Long.valueOf((String)postMap.get("sysBrandId"));
        Long sysCompanyId = Long.valueOf((String)postMap.get("sysCompanyId"));
        Long createTime = Long.valueOf((String)postMap.get("CreateTime"));
        ChannelsWxServiceComponentPOExample channelsWxServiceComponentPOExample = new ChannelsWxServiceComponentPOExample();
        channelsWxServiceComponentPOExample.createCriteria().andServiceIdEqualTo(serviceId).andValidEqualTo(Integer.valueOf(1));
        List channelsWxServiceComponentPOS = this.channelsWxServiceComponentPOMapper.selectByExample(channelsWxServiceComponentPOExample);
        log.info("channelsWxServiceComponentPOS: {}", (Object)JacksonUtil.list2Json((List)channelsWxServiceComponentPOS));
        if (CollectionUtils.isEmpty((Collection)channelsWxServiceComponentPOS)) {
            return;
        }
        ChannelsWxServiceComponentPO channelsWxServiceComponentPO = (ChannelsWxServiceComponentPO)channelsWxServiceComponentPOS.get(0);
        String componentAppId = channelsWxServiceComponentPO.getComponentAppId();
        ChannelsComponentAuthPOExample channelsComponentAuthPOExample = new ChannelsComponentAuthPOExample();
        channelsComponentAuthPOExample.createCriteria().andComponentAppIdEqualTo(componentAppId).andValidEqualTo(Integer.valueOf(1));
        List channelsComponentAuthPOS = this.channelsComponentAuthPOMapper.selectByExample(channelsComponentAuthPOExample);
        log.info("channelsComponentAuthPOS: {}", (Object)JacksonUtil.list2Json((List)channelsComponentAuthPOS));
        if (CollectionUtils.isEmpty((Collection)channelsComponentAuthPOS)) {
            return;
        }
        String componentAccessToken = ((ChannelsComponentAuthPO)channelsComponentAuthPOS.get(0)).getComponentAccessToken();
        GetServiceBuyerExpireTimeResultVO serviceBuyerExpireTime = WechatTools.getServiceBuyerExpireTime((String)serviceId, (String)authAppid, (String)componentAccessToken);
        log.info("serviceBuyerExpireTime: {}", (Object)JacksonUtil.bean2Json((Object)serviceBuyerExpireTime));
        ChannelsSmallShopInfoPO channelsSmallShopInfoPO = new ChannelsSmallShopInfoPO();
        channelsSmallShopInfoPO.setSysCompanyId(sysCompanyId);
        channelsSmallShopInfoPO.setSysBrandId(sysBrandId);
        channelsSmallShopInfoPO.setAppId(authAppid);
        channelsSmallShopInfoPO.setShopAuthStartTime(Date.from(TimeUtil.fromMilliseconds((long)(createTime * 1000L)).toInstant(ZoneOffset.of("+8"))));
        if (serviceBuyerExpireTime != null) {
            Long expireTime = serviceBuyerExpireTime.getSpec_list().stream().map(GetServiceBuyerExpireTimeResultVO.Spec::getExpire_time).max(Comparator.naturalOrder()).get();
            channelsSmallShopInfoPO.setShopAuthEndTime(Date.from(TimeUtil.fromMilliseconds((long)(expireTime * 1000L)).toInstant(ZoneOffset.of("+8"))));
            channelsSmallShopInfoPO.setSysCompanyId(sysCompanyId);
            channelsSmallShopInfoPO.setSysCompanyId(sysCompanyId);
        }
        channelsSmallShopInfoPO.setShopAuthType(SystemConstants.SHOP_AUTH_TYPE_SERVICE_MARKET);
        channelsSmallShopInfoPO.setCreateDate(new java.util.Date());
        channelsSmallShopInfoPO.setUpdateDate(new java.util.Date());
        channelsSmallShopInfoPO.setValid(Integer.valueOf(1));
        this.channelsSmallShopInfoPOMapper.insertSelective(channelsSmallShopInfoPO);
        ApiGetAuthorizerInfoResultVO apiGetAuthorizerInfoResultVO = WechatTools.apiGetAuthorizerInfo((String)componentAppId, (String)authAppid, (String)componentAccessToken);
        log.info("apiGetAuthorizerInfoResultVO: {}", (Object)JacksonUtil.bean2Json((Object)apiGetAuthorizerInfoResultVO));
        ChannelsComponentAuthorizerAuthPO channelsComponentAuthorizerAuthPO = new ChannelsComponentAuthorizerAuthPO();
        channelsComponentAuthorizerAuthPO.setComponentAppId(componentAppId);
        channelsComponentAuthorizerAuthPO.setAuthorizerAppId(authAppid);
        channelsComponentAuthorizerAuthPO.setServiceId(serviceId);
        channelsComponentAuthorizerAuthPO.setAuthorizerRefreshToken(apiGetAuthorizerInfoResultVO.getAuthorizer_refresh_token());
        channelsComponentAuthorizerAuthPO.setCreateTime(new java.util.Date());
        channelsComponentAuthorizerAuthPO.setUpdateTime(new java.util.Date());
        channelsComponentAuthorizerAuthPO.setValid(Integer.valueOf(1));
        this.channelsComponentAuthorizerAuthPOMapper.insertSelective(channelsComponentAuthorizerAuthPO);
        String authorizerAccessToken = this.weChatService.getChannelsShopAccessToken(authAppid, componentAppId);
        GetChannelsBasicsInfoResultVO channelsBasicsInfo = WechatTools.getChannelsBasicsInfo((String)authorizerAccessToken);
        log.info("channelsBasicsInfo: {}", (Object)JacksonUtil.bean2Json((Object)channelsBasicsInfo));
        String openAccount = WechatTools.getOpenAccount((String)authorizerAccessToken);
        log.info("openAccount: {}", (Object)openAccount);
        if (channelsBasicsInfo != null) {
            channelsSmallShopInfoPO.setNickName(channelsBasicsInfo.getNickname());
            channelsSmallShopInfoPO.setHeadImgUrl(channelsBasicsInfo.getHeadimg_url());
            channelsSmallShopInfoPO.setShopType(channelsBasicsInfo.getSubject_type());
            channelsSmallShopInfoPO.setShopStatus(channelsBasicsInfo.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)openAccount)) {
            channelsSmallShopInfoPO.setIsBindWechatOpenPlatform(Integer.valueOf(1));
        } else {
            channelsSmallShopInfoPO.setIsBindWechatOpenPlatform(Integer.valueOf(0));
        }
        this.channelsSmallShopInfoPOMapper.updateByPrimaryKeySelective(channelsSmallShopInfoPO);
    }
}

