/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.channelsmallshop.mq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.bizvane.channelsmallshop.service.constants.WechatConstants;
import com.bizvane.channelsmallshop.service.entity.po.ChannelsComponentAuthPO;
import com.bizvane.channelsmallshop.service.entity.po.ChannelsComponentAuthPOExample;
import com.bizvane.channelsmallshop.service.mapper.ChannelsComponentAuthPOMapper;
import com.bizvane.channelsmallshop.service.utils.WechatTools;
import com.bizvane.channelsmallshop.service.utils.msgcrypt.AesException;
import com.bizvane.channelsmallshop.service.utils.msgcrypt.WXBizMsgCrypt;
import com.bizvane.channelsmallshop.service.utils.msgcrypt.XMLParse;
import com.bizvane.channelsmallshop.service.vo.wechat.ApiComponentTokenParamVO;
import com.bizvane.channelsmallshop.service.vo.wechat.ApiComponentTokenResultVO;
import com.bizvane.channelsmallshop.service.vo.wechat.ComponentVerifyTicketVO;
import com.bizvane.channelsmallshop.service.vo.wechat.WechatBaseRequestVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RocketMQMessageListener(topic="channel_wx_topic", tags={"channel_component_verify_ticket_tag"})
public class WechatComponentVerifyTicketConsumer
implements RocketMQListener<WechatBaseRequestVO> {
    private static final Logger log = LoggerFactory.getLogger(WechatComponentVerifyTicketConsumer.class);
    @Autowired
    private ChannelsComponentAuthPOMapper channelsComponentAuthPOMapper;

    public void onMessage(ConsumerMessage<WechatBaseRequestVO> consumerMessage) {
        log.info("WechatComponentVerifyTicketConsumer consumerMessage: {}", (Object)JacksonUtil.bean2Json(consumerMessage));
        WechatBaseRequestVO message = (WechatBaseRequestVO)consumerMessage.getMessage();
        String postData = message.getPostData();
        String nonce = message.getNonce();
        String timestamp = message.getTimestamp();
        String msgSignature = message.getMsg_signature();
        Object[] encrypt = new Object[]{};
        try {
            encrypt = XMLParse.extract((String)postData);
        }
        catch (AesException e) {
            log.info("WechatComponentVerifyTicketConsumer extract exception: {}", (Throwable)e);
            return;
        }
        String appId = String.valueOf(encrypt[0]);
        ChannelsComponentAuthPOExample componentAuthPOExample = new ChannelsComponentAuthPOExample();
        componentAuthPOExample.createCriteria().andComponentAppIdEqualTo(appId).andValidEqualTo(Integer.valueOf(1));
        List channelsComponentAuthPOS = this.channelsComponentAuthPOMapper.selectByExample(componentAuthPOExample);
        log.info("channelsComponentAuthPOS: {}", (Object)JacksonUtil.list2Json((List)channelsComponentAuthPOS));
        if (CollectionUtils.isEmpty((Collection)channelsComponentAuthPOS)) {
            return;
        }
        ChannelsComponentAuthPO channelsComponentAuthPO = (ChannelsComponentAuthPO)channelsComponentAuthPOS.get(0);
        Date componentAccessTokenRefreshTime = channelsComponentAuthPO.getComponentAccessTokenRefreshTime();
        String token = channelsComponentAuthPO.getToken();
        String encodingAeskey = channelsComponentAuthPO.getEncodingAeskey();
        String decryptMsg = null;
        try {
            WXBizMsgCrypt wxBizMsgCrypt = new WXBizMsgCrypt(token, encodingAeskey, appId);
            decryptMsg = wxBizMsgCrypt.decryptMsg(msgSignature, timestamp, nonce, postData);
        }
        catch (AesException e) {
            log.info("WechatComponentVerifyTicketConsumer decryptMsg exception: {}", (Throwable)e);
            return;
        }
        log.info("WechatComponentVerifyTicketConsumer decryptMsg: {}", (Object)decryptMsg);
        Map postMap = WechatTools.getPostMap((String)decryptMsg);
        ComponentVerifyTicketVO componentVerifyTicketVO = (ComponentVerifyTicketVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)postMap), ComponentVerifyTicketVO.class);
        Long createTime = componentVerifyTicketVO.getCreateTime();
        String componentVerifyTicket = componentVerifyTicketVO.getComponentVerifyTicket();
        String infoType = componentVerifyTicketVO.getInfoType();
        if (!"component_verify_ticket".equals(infoType)) {
            log.info("WechatComponentVerifyTicketConsumer \u4e8b\u4ef6\u7c7b\u578b\u4e0d\u4e00\u81f4 msgSignature: {}", (Object)msgSignature);
            return;
        }
        Long currentSecond = System.currentTimeMillis() / 1000L;
        if (currentSecond - createTime > WechatConstants.WX_CALL_BACK_MAX_TIME_LIMIT_SECOND) {
            return;
        }
        if ((componentAccessTokenRefreshTime == null || currentSecond - componentAccessTokenRefreshTime.getTime() / 1000L > WechatConstants.WX_CALL_BACK_MAX_TIME_LIMIT_SECOND) && StringUtils.isNotBlank((CharSequence)channelsComponentAuthPO.getComponentAppSecret())) {
            ApiComponentTokenParamVO paramVO = new ApiComponentTokenParamVO();
            paramVO.setComponent_verify_ticket(componentVerifyTicket);
            paramVO.setComponent_appid(channelsComponentAuthPO.getComponentAppId());
            paramVO.setComponent_appsecret(channelsComponentAuthPO.getComponentAppSecret());
            ApiComponentTokenResultVO apiComponentTokenResultVO = WechatTools.apiComponentToken((ApiComponentTokenParamVO)paramVO);
            if (apiComponentTokenResultVO != null) {
                channelsComponentAuthPO.setComponentAccessToken(apiComponentTokenResultVO.getComponent_access_token());
                channelsComponentAuthPO.setComponentAccessTokenRefreshTime(new Date());
            }
        }
        channelsComponentAuthPO.setComponentVerifyTicketTime(new Date());
        channelsComponentAuthPO.setComponentVerifyTicket(componentVerifyTicket);
        channelsComponentAuthPO.setUpdateTime(new Date());
        this.channelsComponentAuthPOMapper.updateByPrimaryKeySelective(channelsComponentAuthPO);
    }
}

