package com.bizvane.centercontrolservice.interfaces;

import com.bizvane.centercontrolservice.models.po.DefCompanyWxRelPo;
import com.bizvane.centercontrolservice.models.vo.DefCompanyWxRelVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.CtrlAccountPO;

import java.util.List;

/**
 * Created by Gavin on 2018/11/26.
 */
public interface CompanyWxService {

    /**
     * 关联企业微信
     *
     * @param poList
     * @return
     */
    ResponseData addCompanyWx(List<DefCompanyWxRelPo> poList, CtrlAccountPO ctrlAccountPO);

    /**
     * 根据企业id和品牌查询企业微信id
     *
     * @return
     */
    ResponseData<DefCompanyWxRelPo> getCompanyWx(Long sysCompanyId, Long sysBrandId);

    /**
     * 根据企业id查询企业微信
     * @param sysCompanyId
     * @return
     */
    ResponseData<List<DefCompanyWxRelPo>> getWxBySysCompanyId(Long sysCompanyId);

    /**
     * 根据企业id查询企业微信id
     *
     * @return
     */
    List<DefCompanyWxRelVO> getCompanyWx(Long sysCompanyId);


    /**
     * 根据企业微信id查询企业id
     *
     * @return
     */
    ResponseData<DefCompanyWxRelPo> getCompanyWxByWxid(String wxId);

    ResponseData<List<DefCompanyWxRelPo>> getCompanyWxByWxIdList(String wxId);
}
