package com.bizvane.centercontrolservice.interfaces;

import com.bizvane.centercontrolservice.models.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

public interface BrandBusinessFusionPayService {

    /**
     * 查询品牌渠道支付配置
     */
    List<BrandBusinessFusionPayMethodVo> getBrandBusinessFusionPayByBrandId(Long sysBrandId, String businessChannelCode);

    /**
     * 保存品牌渠道支付配置,预作废,使用saveBusinessFusionPay()方法
     */
    @Deprecated
    ResponseData saveBrandBusinessFusionPay(BrandBusinessFusionPayMethodSaveVo brandBusinessFusionPayMethodSaveVo);

    /**
     * 保存业务支付配置
     * @param brandBusinessFusionPayCurrentVo
     * @return
     */
    ResponseData<String> saveBusinessFusionPay(BrandBusinessFusionPayCurrentVo brandBusinessFusionPayCurrentVo);

    /**
     * 修改业务支付配置
     * @param brandBusinessFusionPayCurrentVo
     * @return
     */
    ResponseData<String> updateBusinessFusionPay(BrandBusinessFusionPayCurrentVo brandBusinessFusionPayCurrentVo);

    /**
     * 分页查询支付配置
     * @param brandBusinessFusionPayRequestVo
     * @return
     */
    ResponseData<PageInfo<BrandBusinessFusionPayVo>> pageBrandBusinessFusionPayVo(BrandBusinessFusionPayRequestVo brandBusinessFusionPayRequestVo);

    /**
     * 查询支付配置详情
     * @param brandBusinessFusionPayRequestVo
     * @return
     */
    ResponseData<BrandBusinessFusionPayVo> getBrandBusinessFusionPayVoByVo(BrandBusinessFusionPayRequestVo brandBusinessFusionPayRequestVo);

    /**
     * 逻辑删除业务支付配置
     * @param brandBusinessFusionPayCurrentVo
     * @return
     */
    ResponseData<String> deleteBusinessFusionPay(BrandBusinessFusionPayCurrentVo brandBusinessFusionPayCurrentVo);

    /**
     * 获取小程序业务支付配置
     * @param brandBusinessFusionPayAppletRequestVo
     * @return
     */
    ResponseData<BrandBusinessFusionPayAppletVo> getBrandBusinessFusionPayAppletVo(BrandBusinessFusionPayAppletRequestVo brandBusinessFusionPayAppletRequestVo);

}
