package com.bizvane.centercontrolservice.models.enums;

import org.springframework.util.StringUtils;

public enum FusionPayTypeChannelRelEnum {

    WXPAY_MERCHANTS("wxpay","merchants","微信商户"),
    WXPAY_UNIONPAY("wxpay","unionpay","微信银联"),
    ALIPAY_MERCHANTS("alipay","merchants","支付宝商户"),
    ALIPAY_PROVIDERS("alipay","providers","支付宝服务商")
    ;

    private String payTypeCode;

    private String payChannelCode;

    private String msg;

    FusionPayTypeChannelRelEnum(String payTypeCode, String payChannelCode, String msg) {
        this.payTypeCode = payTypeCode;
        this.payChannelCode = payChannelCode;
        this.msg = msg;
    }

    public static FusionPayTypeChannelRelEnum getInstance(String typeCode,String channelCode) {
        if(StringUtils.isEmpty(typeCode) || StringUtils.isEmpty(channelCode)){
            return null;
        }
        for (FusionPayTypeChannelRelEnum value : FusionPayTypeChannelRelEnum.values()) {
            if(value.getPayTypeCode().equalsIgnoreCase(typeCode)
                    && value.getPayChannelCode().equalsIgnoreCase(channelCode)){
                return value;
            }
        }
        return null;
    }

    public String getPayTypeCode() {
        return payTypeCode;
    }

    public String getPayChannelCode() {
        return payChannelCode;
    }

    public String getMsg() {
        return msg;
    }
}
