package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.po.SysCompanyFusionPayRecordAlipayProvidersPo;
import com.bizvane.centercontrolservice.models.po.SysCompanyFusionPayRecordPo;
import com.bizvane.centercontrolservice.models.vo.SysCompanyFusionPayRecordSearchVo;
import com.bizvane.centercontrolservice.models.vo.SysCompanyFusionPayRecordVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

@FeignClient(value = "${feign.client.centercontrol.name}",path = "${feign.client.centercontrol.path}/sysCompanyFusionPayRecordRpc")
public interface SysCompanyFusionPayRecordServiceRpc {

    /**
     * 中台-支付管理 列表查询
     */
    @GetMapping("getFusionPayRecordBCompanyId")
    ResponseData<PageInfo<SysCompanyFusionPayRecordVo>> getFusionPayRecordBCompanyId(SysCompanyFusionPayRecordSearchVo sysCompanyFusionPayRecordSearchVo);

    /**
     * 中台-支付管理 修改备注名
     */
    @PostMapping("modifyFusionPayRecordRemarkName")
    ResponseData modifyFusionPayRecordRemarkName(SysCompanyFusionPayRecordPo sysCompanyFusionPayRecordPo, SysAccountPO stageUser);


    /**
     * 中台-支付管理 修改支付宝服务商资料
     */
    @PostMapping("modifyAlipayProviders")
    ResponseData modifyAlipayProviders(SysCompanyFusionPayRecordAlipayProvidersPo sysCompanyFusionPayRecordAlipayProvidersPo, SysAccountPO stageUser);


    @PostMapping("modifyAlipayProvidersAppIdByPid")
    Integer modifyAlipayProvidersAppIdByPid(String pid, String appId,Integer AlipayProvidersId);
}
