package com.bizvane.centercontrolservice.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class WechatAuthVo {

    @ApiModelProperty(value = "企业id", name = "companyId", required = true, example = "")
    private Long companyId;

    @ApiModelProperty(value = "企业名称", name = "companyName", required = false, example = "")
    private String companyName;

    @ApiModelProperty(value = "企微账号", name = "qywxWechatAccount", required = false, example = "")
    private String qywxWechatAccount;

    @ApiModelProperty(value = "员工编号", name = "qyStaffCode", required = false, example = "")
    private String qyStaffCode;

    @ApiModelProperty(value = "导购助手角色 1:导购 2:店长", name = "qyStaffRoleId", required = false, example = "")
    private Long qyStaffRoleId;

    @ApiModelProperty(value = "是否启用商秀(true:启用，false:禁用)", name = "isEnableShow", required = false, example = "")
    private Boolean isEnableShow;

    @ApiModelProperty(value = "是否启用区域通(true:启用，false:禁用)", name = "isEnableReg", required = false, example = "")
    private Boolean isEnableReg;

    @ApiModelProperty(value = "中台账号ID", name = "sysAccountId", required = false, example = "",hidden = true)
    private Long sysAccountId;

    @Override
    public String toString() {
        return "WechatAuthVo{" +
                "companyId=" + companyId +
                ", companyName='" + companyName + '\'' +
                ", qywxWechatAccount='" + qywxWechatAccount + '\'' +
                ", qyStaffCode='" + qyStaffCode + '\'' +
                ", qyStaffRoleId=" + qyStaffRoleId +
                ", isEnableShow=" + isEnableShow +
                ", isEnableReg=" + isEnableReg +
                ", sysAccountId=" + sysAccountId +
                '}';
    }
}