package com.bizvane.centercontrolservice.interfaces;

import com.bizvane.centercontrolservice.models.po.CtrlAccountPo;
import com.bizvane.centercontrolservice.models.vo.CtrlAccountVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;

import java.util.List;
import java.util.Map;

;

/**
 * @author liufq
 * @date on 2018/6/27 18:26
 * @description
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */
public interface CtrlAccountService {

    /**
     * 通过手机号查询中控账号
     *
     * @param phoneNumber
     * @return
     */
    ResponseData<CtrlAccountPo> getCtrlAccountByPhoneNumber(String phoneNumber);

    /**
     * 添加账号
     *
     * @param vo
     * @param
     * @return
     */
    @ApiOperation(value = "添加账号", notes = "账号管理", tags = {"账号"})
    ResponseData<Long> addCtrlAccount(CtrlAccountVo vo);

    /**
     * 修改账号
     *
     * @param vo
     * @return
     */
    @ApiOperation(value = "编辑账号", notes = "账号管理", tags = {"账号"})
    ResponseData<Long> updateCtrlAccount(CtrlAccountVo vo);

    /**
     * 获取账号列表并分页
     *
     * @param
     * @return
     */
    @ApiOperation(value = "账号管理列表查询", notes = "账号管理", tags = {"账号"})
    List<CtrlAccountVo> getCtrlAccountList(CtrlAccountVo vo);

    /**
     * 商帆账号状态修改
     *
     * @param ctrlAccountVo
     * @return
     */
    @ApiOperation(value = "商帆账号状态修改", notes = "账号管理", tags = {"账号"})
    ResponseData<String> updateAccountState(CtrlAccountVo ctrlAccountVo);

    /**
     * 根据id查询账号详情
     *
     * @param ctrlAccountId
     * @return
     */
    @ApiOperation(value = "根据id查询账号详情", notes = "账号管理", tags = {"账号"})
    ResponseData<CtrlAccountVo> queryVOById(String ctrlAccountId);


    /**
     * 获取验证码
     *
     * @param vo
     * @return
     */
    @ApiOperation(value = "获取验证码", notes = "账号管理", tags = {"账号"})
    ResponseData<Map<String, String>> getVerifCode(CtrlAccountVo vo);

    /**
     * 校验验证码
     *
     * @param vo
     * @return
     */
    @ApiOperation(value = "校验验证码", notes = "账号管理", tags = {"账号"})
    ResponseData<Long> checkVerifCode(CtrlAccountVo vo);

    /**
     * 校验密码
     *
     * @param vo
     * @return
     */
    @ApiOperation(value = "校验密码", notes = "账号管理", tags = {"账号"})
    ResponseData<Long> checkPwd(CtrlAccountVo vo);

    /**
     * 修改密码
     *
     * @param vo
     * @return
     */
    @ApiOperation(value = "修改密码", notes = "账号管理", tags = {"账号"})
    ResponseData<Long> updatePwd(CtrlAccountVo vo);


    /**
     * 获取随机密码
     *
     * @param vo
     * @return
     */
    ResponseData<Map<String, String>> getRandomPwd(CtrlAccountVo vo);

    /**
     * 修改随机密码
     *
     * @param vo
     * @return
     */
    ResponseData<Map<String, String>> updateRandomPwd(CtrlAccountVo vo);

    /**
     * 修改登录用户密码
     *
     * @param vo
     * @return
     * */
    ResponseData<Long> updateCtrlAccountPwd(CtrlAccountVo vo);




}