package com.bizvane.cdp.algorithm.facade.interfaces;

import com.bizvane.cdp.facade.model.req.AddOrModifyEventAnalysisAbilityReqVO;
import com.bizvane.cdp.facade.model.rsp.AddOrModifyEventAnalysisAbilityRespVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(value = "${feign.client.cdp-algorithm.name}", path = "${feign.client.cdp-algorithm.path}/eventAnalysis")
@Api(value = "事件分析", tags = {"事件分析"})
public interface CdpEventAnalysisFeign {

    @PostMapping("/queryList")
    ResponseData<AddOrModifyEventAnalysisAbilityRespVO> queryList(@RequestBody AddOrModifyEventAnalysisAbilityReqVO reqVO);

    @PostMapping("/queryLineChart")
    ResponseData<AddOrModifyEventAnalysisAbilityRespVO> queryLineChart(@RequestBody AddOrModifyEventAnalysisAbilityReqVO reqVO);

    @PostMapping("/queryStackGroupColumnChart")
    ResponseData<AddOrModifyEventAnalysisAbilityRespVO> queryStackGroupColumnChart(@RequestBody AddOrModifyEventAnalysisAbilityReqVO reqVO);

    @PostMapping("/queryPieChart")
    ResponseData<AddOrModifyEventAnalysisAbilityRespVO> queryPieChart(@RequestBody AddOrModifyEventAnalysisAbilityReqVO reqVO);

}
