package com.bizvane.cdp.algorithm.facade.interfaces;

import com.bizvane.cdp.facade.model.req.AddOrModifyAttributeAnalysisAbilityReqVO;
import com.bizvane.cdp.facade.model.rsp.AddOrModifyAttributeAnalysisAbilityRespVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "${feign.client.cdp-algorithm.name}", path = "${feign.client.cdp-algorithm.path}/attributeAnalysis")
@Api(value = "事件分析", tags = {"事件分析"})
public interface CdpAttributeAnalysisFeign {

    @PostMapping("/queryList")
    ResponseData<AddOrModifyAttributeAnalysisAbilityRespVO> queryList(@RequestBody AddOrModifyAttributeAnalysisAbilityReqVO reqVO);

    @PostMapping("/queryLineChart")
    ResponseData<AddOrModifyAttributeAnalysisAbilityRespVO> queryLineChart(@RequestBody AddOrModifyAttributeAnalysisAbilityReqVO reqVO);

    @PostMapping("/queryStackGroupColumnChart")
    ResponseData<AddOrModifyAttributeAnalysisAbilityRespVO> queryStackGroupColumnChart(@RequestBody AddOrModifyAttributeAnalysisAbilityReqVO reqVO);

    @PostMapping("/queryPieChart")
    ResponseData<AddOrModifyAttributeAnalysisAbilityRespVO> queryPieChart(@RequestBody AddOrModifyAttributeAnalysisAbilityReqVO reqVO);

}
