package com.bizvane.cdp.algorithm.facade.interfaces.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class CdpMarketingResultBranchEventReqVO implements Serializable {
    private static final long serialVersionUID = 7212438483568354881L;

    @NotNull(message = "企业ID为空")
    @ApiModelProperty(value = "企业ID")
    private Long sysCompanyId;

    @NotNull(message = "品牌ID为空")
    @ApiModelProperty(value = "品牌ID")
    private Long sysBrandId;

    @ApiModelProperty(value = "组件配置规则")
    private String moduleConfigRule;

    @NotBlank(message = "营销编号为空")
    @ApiModelProperty(value = "营销编号")
    private String marketingCode;

    @NotBlank(message = "版本编号为空")
    @ApiModelProperty(value = "版本编号")
    private String versionCode;

    @NotBlank(message = "组件类型为空")
    @ApiModelProperty(value = "组件类型")
    private String moduleType;

    @NotBlank(message = "组件编号为空")
    @ApiModelProperty(value = "组件编号")
    private String moduleCode;

    @ApiModelProperty(value = "回收事件表名")
    private String eventTable;

    @ApiModelProperty(value = "回收开始时间")
    private Date startTime;

    @NotEmpty(message = "回收信息为空")
    @ApiModelProperty(value = "回收信息")
    private List<CdpMarketingResultBranchEventReqVO.ResultBranchEventRelation> eventRelationList;

    @Data
    public static class ResultBranchEventRelation implements Serializable{
        private static final long serialVersionUID = 1623829636612314039L;

        @NotNull(message = "画布结果类型为空")
        @ApiModelProperty(value = "画布结果类型")
        private Integer branchType;

        @NotBlank(message = "画布结果流程code为空")
        @ApiModelProperty(value = "画布结果流程code")
        private String flowCode;

        @ApiModelProperty(value = "回收事件字段值")
        private String eventTableFieldValue;


    }
}
