package com.bizvane.cdp.algorithm.facade.interfaces.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class CdpAlgorithmExecuteMarketingReqVO {


    @ApiModelProperty(value = "企业ID")
    private Long sysCompanyId;
    @ApiModelProperty(value = "品牌ID")
    private Long sysBrandId;
    @ApiModelProperty(value = "组件配置规则")
    private String moduleConfigRule;
    @ApiModelProperty(value = "批次号")
    private String batchNumber;
    @ApiModelProperty(value = "营销编号")
    private String marketingCode;
    @ApiModelProperty(value = "版本编号")
    private String versionCode;
    @ApiModelProperty(value = "组件类型")
    private String moduleType;
    @ApiModelProperty(value = "组件编号")
    private String moduleCode;
    @ApiModelProperty("下一步流程编号,多分支回收使用")
    private String nextFlowCode;
    @ApiModelProperty(value = "营销类型（1事件营销 2单次营销 3循环营销）")
    private Integer marketingType;
    @ApiModelProperty(value = "事件开始时间")
    private Date eventStartTime;
    @ApiModelProperty(value = "事件结束时间")
    private Date eventEndTime;
    @ApiModelProperty(value = "限制进入次数", notes = "数值范围为[1,999]")
    private Integer limitInNumber;
    @ApiModelProperty(value = "限制类型（0不限制 1限制）")
    private Integer limitType;
}
