package com.bizvane.cdp.algorithm.facade.interfaces;

import com.bizvane.cdp.algorithm.facade.interfaces.model.CdpCustomerLabelDetailReqVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(value = "${feign.client.cdp-algorithm.name}", path = "${feign.client.cdp-algorithm.path}/cdpCustomerLabelDetail")
@Api(value = "客户标签圈选人群详情", tags = {"客户标签圈选人群详情"})
public interface CdpCustomerLabelDetailFeign {

    @PostMapping("/getCustomerLabelDetailByLabelId")
    ResponseData<List<Object>> getCustomerLabelDetailByLabelId(@RequestBody CdpCustomerLabelDetailReqVO reqVO);


}
