/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.open.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.vo.BrowseVO;
import com.wmeimob.fastboot.open.service.MiniprogramUserService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import me.hao0.wechat.model.base.JSCode2SessionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MiniprogramUserServiceImpl
implements MiniprogramUserService {
    private static final Logger log = LoggerFactory.getLogger(MiniprogramUserServiceImpl.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    private final String BROWSE_KEY = "opens:authorizer_appids:%s:openids:%s:browse";

    public void save(String appid, JSCode2SessionResponse response) {
        log.info("MiniprogramUserServiceImpl#save appid:{},response:{}", (Object)appid, (Object)JSON.toJSONString((Object)response));
        this.stringRedisTemplate.opsForValue().set((Object)("opens:authorizer_appids:" + appid + ":openids:" + response.getOpenid() + ":jscode2session"), (Object)JSONObject.toJSONString((Object)response), 7L, TimeUnit.DAYS);
    }

    public JSCode2SessionResponse get(String appid, String openid) {
        return (JSCode2SessionResponse)JSONObject.parseObject((String)((String)this.stringRedisTemplate.opsForValue().get((Object)("opens:authorizer_appids:" + appid + ":openids:" + openid + ":jscode2session"))), JSCode2SessionResponse.class);
    }

    public void saveUser(String appid, String openid, User user) {
        log.info("MiniprogramUserServiceImpl#saveUser appid:{} , openid:{} , user:{}", new Object[]{appid, openid, JSON.toJSONString((Object)user)});
        this.stringRedisTemplate.opsForValue().set((Object)("opencard2:authorizer_appids:" + appid + ":openids:" + openid + ":jscode2session"), (Object)JSONObject.toJSONString((Object)user), 7L, TimeUnit.DAYS);
    }

    public User getUser(String appid, String openid) {
        return (User)JSONObject.parseObject((String)((String)this.stringRedisTemplate.opsForValue().get((Object)("opencard2:authorizer_appids:" + appid + ":openids:" + openid + ":jscode2session"))), User.class);
    }

    public ResponseData<Integer> logOut(String appid, String openid) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        log.info("MiniprogramUserServiceImpl#logOut appid:{},openId:{}", (Object)appid, (Object)openid);
        Boolean opens = this.stringRedisTemplate.delete((Object)("opens:authorizer_appids:" + appid + ":openids:" + openid + ":jscode2session"));
        log.info("MiniprogramUserServiceImpl#logOut opens:{}", (Object)opens);
        Boolean opencard2 = this.stringRedisTemplate.delete((Object)("opencard2:authorizer_appids:" + appid + ":openids:" + openid + ":jscode2session"));
        log.info("MiniprogramUserServiceImpl#logOut opencard2:{}", (Object)opencard2);
        return responseData;
    }

    public void saveBrowse(String appId, String openId, BrowseVO browseVO) {
        String key = String.format("opens:authorizer_appids:%s:openids:%s:browse", appId, openId);
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSON.toJSONString((Object)browseVO));
    }

    public BrowseVO getBrowse(String appId, String openId) {
        String key = String.format("opens:authorizer_appids:%s:openids:%s:browse", appId, openId);
        return (BrowseVO)JSONObject.parseObject((String)((String)this.stringRedisTemplate.opsForValue().get((Object)key)), BrowseVO.class);
    }
}

