/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.wx_msg_notice.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.WXTemplateJumpPages;
import com.wmeimob.fastboot.bizvane.entity.WxMsgData;
import com.wmeimob.fastboot.bizvane.entity.WxMsgResult;
import com.wmeimob.fastboot.bizvane.entity.WxMsgTemplate;
import com.wmeimob.fastboot.bizvane.enums.WXMsgTemplate.WXMsgTemplateStrLengthEnum;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MsgWxNoticeRecordPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MsgWxSubScribePOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MsgWxTemplatePOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrderItemsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.WechatMchPOMapper;
import com.wmeimob.fastboot.bizvane.po.MsgWxNoticeRecordPO;
import com.wmeimob.fastboot.bizvane.po.MsgWxTemplatePO;
import com.wmeimob.fastboot.bizvane.po.MsgWxTemplatePOExample;
import com.wmeimob.fastboot.bizvane.po.OrderItemsPO;
import com.wmeimob.fastboot.bizvane.po.OrderItemsPOExample;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.po.OrdersPOExample;
import com.wmeimob.fastboot.bizvane.po.WechatMchPO;
import com.wmeimob.fastboot.bizvane.po.WechatMchPOExample;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.wx_msg_notice.WXMsgNoticeService;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.utils.wxsubscribe.WXTemplateDataCreateUtil;
import com.wmeimob.fastboot.bizvane.utils.wxsubscribe.WxSubscribeSendUtil;
import com.wmeimob.fastboot.bizvane.vo.wx_msg_template.WXMsgTemplateNoticeVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import me.hao0.wechat.exception.WechatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class WXMsgNoticeServiceImpl
implements WXMsgNoticeService {
    private static final Logger log = LoggerFactory.getLogger(WXMsgNoticeServiceImpl.class);
    @Resource
    private MsgWxTemplatePOMapper msgWxTemplatePOMapper;
    @Resource
    private MarketActivityPOMapper marketActivityPOMapper;
    @Resource
    private MsgWxSubScribePOMapper msgWxSubScribePOMapper;
    @Resource
    private MsgWxNoticeRecordPOMapper msgWxNoticeRecordPOMapper;
    @Resource
    private OrdersPOMapper ordersPOMapper;
    @Resource
    private OrderItemsPOMapper orderItemsPOMapper;
    @Resource
    private WechatMchPOMapper wechatMchPOMapper;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private WxSubscribeSendUtil wxSubscribeSendUtil;

    public String searchTemplateByMerchantId(Integer merchantId, Integer templateType) {
        log.info("WxTemplateServiceImpl searchTemplateByMerchantId:{}", (Object)merchantId);
        MsgWxTemplatePOExample msgWxTemplateExample = new MsgWxTemplatePOExample();
        msgWxTemplateExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andTemplateTypeEqualTo(templateType);
        List msgWxTemplates = this.msgWxTemplatePOMapper.selectByExample(msgWxTemplateExample);
        log.info("msgWxTemplates:{}", (Object)JSON.toJSONString((Object)msgWxTemplates));
        if (msgWxTemplates == null || msgWxTemplates.size() == 0) {
            return null;
        }
        if (msgWxTemplates.size() > 1) {
            throw new WechatException("\u67e5\u8be2\u51fa\u591a\u4e2a\u6a21\u677f\u6570\u636e");
        }
        return ((MsgWxTemplatePO)msgWxTemplates.get(0)).getTemplateId();
    }

    public ResponseData searchTemplatesByMerchantId(Integer merchantId) {
        log.info("WxTemplateServiceImpl searchTemplatesByMerchantId:{}", (Object)merchantId);
        MsgWxTemplatePOExample msgWxTemplateExample = new MsgWxTemplatePOExample();
        msgWxTemplateExample.createCriteria().andValidEqualTo(Boolean.TRUE).andActiveEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId);
        List msgWxTemplates = this.msgWxTemplatePOMapper.selectByExample(msgWxTemplateExample);
        log.info("msgWxTemplates:{}", (Object)JSON.toJSONString((Object)msgWxTemplates));
        return ResponseUtil.getSuccessData((Object)msgWxTemplates);
    }

    @Transactional
    public ResponseData payOrderNotice(WXMsgTemplateNoticeVO vo) {
        String accessToken;
        StringBuilder goodNamesBuilder = new StringBuilder();
        OrdersPOExample searchOrder = new OrdersPOExample();
        searchOrder.createCriteria().andValidEqualTo(Boolean.TRUE).andIdEqualTo(vo.getOrderId());
        List ordersPOS = this.ordersPOMapper.selectByExample(searchOrder);
        log.info("ordersPOS:{}", (Object)JSON.toJSONString((Object)ordersPOS));
        if (CollectionUtils.isEmpty((Collection)ordersPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (ordersPOS.size() > 1) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u4fe1\u606f\u8fc7\u591a");
        }
        if (((OrdersPO)ordersPOS.get(0)).getMerchantId() == null || StringUtils.isEmpty((Object)((OrdersPO)ordersPOS.get(0)).getWechatOpenid())) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u7f3a\u5c11\u90e8\u5206\u6570\u636e");
        }
        OrdersPO order = (OrdersPO)ordersPOS.get(0);
        Integer merchantId = order.getMerchantId();
        String touser = order.getWechatOpenid();
        vo.setUserName(order.getUserName());
        vo.setPhone(order.getMobile());
        vo.setOrderNo(order.getOrderNo());
        OrderItemsPOExample searchOrderItem = new OrderItemsPOExample();
        searchOrderItem.createCriteria().andValidEqualTo(Boolean.TRUE).andOrderIdEqualTo(vo.getOrderId());
        List orderItemsPOS = this.orderItemsPOMapper.selectByExample(searchOrderItem);
        log.info("orderItemsPOS:{}", (Object)JSON.toJSONString((Object)orderItemsPOS));
        if (CollectionUtils.isEmpty((Collection)ordersPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (orderItemsPOS.size() < 3) {
            for (OrderItemsPO orderItemsPO : orderItemsPOS) {
                goodNamesBuilder.append(orderItemsPO.getGoodsName()).append("/");
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                goodNamesBuilder.append(((OrderItemsPO)orderItemsPOS.get(i)).getGoodsName()).append("/");
            }
        }
        String goodNames = goodNamesBuilder.toString().substring(0, goodNamesBuilder.length() - 1);
        WechatMchPOExample wechatMchPOExample = new WechatMchPOExample();
        wechatMchPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId);
        List wechatMchPOS = this.wechatMchPOMapper.selectByExample(wechatMchPOExample);
        log.info("wechatMchPOS:{}", (Object)JSON.toJSONString((Object)wechatMchPOS));
        if (CollectionUtils.isEmpty((Collection)wechatMchPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u5c0f\u7a0b\u5e8fappId\u4e0d\u5b58\u5728");
        }
        if (wechatMchPOS.size() > 1) {
            return ResponseUtil.getFailedMsg((String)"\u5c0f\u7a0b\u5e8fappId\u8fc7\u591a");
        }
        try {
            accessToken = this.bizvaneInterface.obtainToken(((WechatMchPO)wechatMchPOS.get(0)).getAppId());
            log.info("\u83b7\u53d6\u5230\u7684\u5f53\u524dtoken\u4e3a accessToken\uff1a{}", JSON.toJSON((Object)accessToken));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseUtil.getFailedMsg((String)"accessToken\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)accessToken)) {
            return ResponseUtil.getFailedMsg((String)"accessToken\u4e3a\u7a7a");
        }
        WxMsgTemplate wxMsgTemplate = new WxMsgTemplate();
        WxMsgData wxMsgData = new WxMsgData();
        wxMsgData.setThing4(WXTemplateDataCreateUtil.createKeyValue((String)"\u60a8\u7684\u8ba2\u5355\u652f\u4ed8\u5b8c\u6210"));
        wxMsgData.setCharacter_string1(WXTemplateDataCreateUtil.createKeyValue((String)WXTemplateDataCreateUtil.lengthCheck((String)vo.getOrderNo(), (WXMsgTemplateStrLengthEnum)WXMsgTemplateStrLengthEnum.character_string)));
        wxMsgData.setThing9(WXTemplateDataCreateUtil.createKeyValue((String)WXTemplateDataCreateUtil.lengthCheck((String)goodNames, (WXMsgTemplateStrLengthEnum)WXMsgTemplateStrLengthEnum.thing)));
        if (order.getPayAmount() == null) {
            order.setPayAmount(BigDecimal.ZERO);
        }
        String amount3Str = order.getPayAmount() + "\u5143";
        wxMsgData.setAmount3(WXTemplateDataCreateUtil.createKeyValue((String)amount3Str));
        String dateString = DateUtil.yyyyMMddHHmmss.format(order.getGmtCreate());
        wxMsgData.setTime5(WXTemplateDataCreateUtil.createKeyValue((String)dateString));
        String replace = JSON.toJSONString((Object)wxMsgData).replace("\\", "");
        Map dataMap = (Map)JSON.parseObject((String)replace, Map.class);
        wxMsgTemplate.setData(dataMap);
        wxMsgTemplate.setTouser(touser);
        wxMsgTemplate.setPage(WXTemplateJumpPages.payOrders);
        wxMsgTemplate.setTemplate_id(vo.getTemplateId());
        ResponseEntity responseEntity = this.wxSubscribeSendUtil.wxSubscribeMessageSend(wxMsgTemplate, accessToken);
        log.info("\u8fd4\u56de\u7ed3\u679c\u4e3a responseEntity\uff1a{}", (Object)responseEntity);
        WxMsgResult result = new WxMsgResult();
        if (responseEntity.getBody() != null) {
            log.info("\u8fd4\u56debody\uff1a{}", responseEntity.getBody());
            result = (WxMsgResult)JSON.parseObject((String)responseEntity.getBody().toString(), WxMsgResult.class);
            if (SysResponseEnum.SUCCESS.getCode() == result.getErrcode().intValue()) {
                log.info("\u8fd4\u56de\u6570\u636e\u6210\u529f");
                return ResponseUtil.getSuccessData((Object)"");
            }
            log.info("\u8fd4\u56de\u6570\u636e\u5931\u8d25");
            return ResponseUtil.getFailedMsg((String)result.getErrmsg());
        }
        return ResponseUtil.getFailedMsg((String)"\u8c03\u7528\u5fae\u4fe1\u6d88\u606f\u8ba2\u9605\u63a5\u53e3\u5931\u8d25");
    }

    @Transactional
    public ResponseData payOrderNoticePre(WXMsgTemplateNoticeVO vo) {
        log.info("WXMsgNoticeServiceImpl#sendGoodsNoticePre vo:{}", (Object)vo);
        MsgWxTemplatePOExample msgWxTemplateCheckExample = new MsgWxTemplatePOExample();
        msgWxTemplateCheckExample.createCriteria().andMerchantIdEqualTo(vo.getMerchantId()).andValidEqualTo(Boolean.TRUE).andTemplateTypeEqualTo(vo.getTemplateType().getCode());
        List msgWxTemplatePOS = this.msgWxTemplatePOMapper.selectByExample(msgWxTemplateCheckExample);
        log.info("msgWxTemplatePOS{}", (Object)JSON.toJSONString((Object)msgWxTemplatePOS));
        if (CollectionUtils.isEmpty((Collection)msgWxTemplatePOS)) {
            log.info("\u672a\u914d\u7f6e\u8ba2\u9605\u6d88\u606f\u5230\u6570\u636e\u5e93\u4e2d");
            return ResponseUtil.getFailedMsg((String)"\u672a\u914d\u7f6e\u8ba2\u9605\u6d88\u606f\u5230\u6570\u636e\u5e93\u4e2d");
        }
        if (msgWxTemplatePOS.size() > 1) {
            log.info("\u6570\u636e\u5e93\u4e2d\u8ba2\u9605\u6d88\u606f\u8fc7\u591a");
            return ResponseUtil.getFailedMsg((String)"\u6570\u636e\u5e93\u4e2d\u8ba2\u9605\u6d88\u606f\u8fc7\u591a");
        }
        MsgWxTemplatePO msgWxTemplatePO = (MsgWxTemplatePO)msgWxTemplatePOS.get(0);
        if (StringUtils.isEmpty((Object)msgWxTemplatePO.getTemplateId())) {
            log.info("\u6a21\u677fid\u4e3a\u7a7a");
            return ResponseUtil.getFailedMsg((String)"\u6a21\u677fid\u4e3a\u7a7a");
        }
        if (!msgWxTemplatePO.getActive().booleanValue()) {
            log.info("\u6a21\u677f\u672a\u6fc0\u6d3b");
            return ResponseUtil.getFailedMsg((String)"\u6a21\u677f\u672a\u6fc0\u6d3b");
        }
        vo.setTemplateId(msgWxTemplatePO.getTemplateId());
        ResponseData responseData = this.payOrderNotice(vo);
        MsgWxNoticeRecordPO insertPo = new MsgWxNoticeRecordPO();
        insertPo.setErrorMsg(responseData.getMessage());
        insertPo.setSendStatus(String.valueOf(responseData.getCode()));
        insertPo.setMerchantId(vo.getMerchantId());
        insertPo.setSendTime(new Date());
        insertPo.setUserName(vo.getUserName());
        insertPo.setUserPhone(vo.getPhone());
        insertPo.setOrderNo(vo.getOrderNo());
        insertPo.setGmtCreate(new Date());
        insertPo.setTemplateType(vo.getTemplateType().getCode());
        log.info("insertPo:{}", (Object)JSON.toJSONString((Object)insertPo));
        this.msgWxNoticeRecordPOMapper.insertSelective(insertPo);
        return ResponseUtil.getSuccessData((Object)"");
    }
}

