/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.seckill.impl;

import com.wmeimob.fastboot.bizvane.config.BizvaneSecurityContext;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityGoodsSecKillPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityOrdersSecKillStockPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityPOMapper;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsSecKillPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersSecKillStockPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPO;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.seckill.SecKillService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillGoodDetailResponseVO;
import com.wmeimob.fastboot.starter.common.entity.RichText;
import com.wmeimob.fastboot.starter.common.service.RichTextService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SecKillServiceImpl
implements SecKillService {
    private static final Logger log = LoggerFactory.getLogger(SecKillServiceImpl.class);
    @Resource
    private MarketActivityGoodsSecKillPOMapper marketActivityGoodsSecKillPOMapper;
    @Resource
    private GoodsPOMapper goodsPOMapper;
    @Resource
    private MarketActivityPOMapper marketActivityPOMapper;
    @Resource
    private MarketActivityGoodsPOMapper marketActivityGoodsPOMapper;
    @Resource
    private GoodsSkuDetailPOMapper goodsSkuDetailPOMapper;
    @Resource
    private MarketActivityOrdersSecKillStockPOMapper marketActivityOrdersSecKillStockPOMapper;
    @Autowired
    private GoodsService goodsService;
    @Autowired
    private RichTextService richTextService;

    public ResponseData<MarketActivitySecKillGoodDetailResponseVO> goodDetail(Integer merchantId, Integer marketActivityGoodsSecKillId) {
        MarketActivitySecKillGoodDetailResponseVO marketActivitySecKillGoodDetailResponseVO = new MarketActivitySecKillGoodDetailResponseVO();
        MarketActivityGoodsSecKillPO marketActivityGoodsSecKillPO = this.marketActivityGoodsSecKillPOMapper.selectByPrimaryKey(marketActivityGoodsSecKillId);
        if (marketActivityGoodsSecKillPO == null || !marketActivityGoodsSecKillPO.getValid().booleanValue()) {
            return ResponseUtil.getFailedMsg((String)"\u79d2\u6740\u6d3b\u52a8\u5546\u54c1\u4e0d\u5b58\u5728!");
        }
        marketActivitySecKillGoodDetailResponseVO.setMarketActivityGoodsSecKillPO(marketActivityGoodsSecKillPO);
        Integer goodsId = marketActivityGoodsSecKillPO.getGoodsId();
        GoodsPO goodsPO = this.goodsPOMapper.selectByPrimaryKey(goodsId);
        if (goodsPO == null || goodsPO.getIsDel().booleanValue() || !goodsPO.getValid().booleanValue() || !goodsPO.getIsShelved().booleanValue()) {
            return ResponseUtil.getFailedMsg((String)"\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u4e0b\u67b6!");
        }
        marketActivitySecKillGoodDetailResponseVO.setGoods(goodsPO);
        RichText byId = this.richTextService.findById(goodsPO.getIntroId());
        marketActivitySecKillGoodDetailResponseVO.setRichText(byId);
        MarketActivityPO marketActivityPO = this.marketActivityPOMapper.selectByPrimaryKey(marketActivityGoodsSecKillPO.getMarketActivityId());
        if (marketActivityPO == null || !marketActivityPO.getValid().booleanValue()) {
            return ResponseUtil.getFailedMsg((String)"\u79d2\u6740\u6d3b\u52a8\u4e0d\u5b58\u5728,\u65e0\u6cd5\u8fdb\u5165\u5546\u54c1\u8be6\u60c5");
        }
        marketActivitySecKillGoodDetailResponseVO.setMarketActivity(marketActivityPO);
        MarketActivityGoodsPOExample marketActivityGoodsPOExample = new MarketActivityGoodsPOExample();
        marketActivityGoodsPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andGoodsIdEqualTo(goodsId).andMarketActivityGoodsSeckillIdEqualTo(marketActivityGoodsSecKillId).andValidEqualTo(Boolean.TRUE);
        List marketActivityGoodsPOList = this.marketActivityGoodsPOMapper.selectByExample(marketActivityGoodsPOExample);
        if (CollectionUtils.isEmpty((Collection)marketActivityGoodsPOList)) {
            return ResponseUtil.getFailedMsg((String)"\u79d2\u6740\u6d3b\u52a8\u4e2d\u672a\u627e\u5230\u8be5\u5546\u54c1!");
        }
        Map<Integer, MarketActivityGoodsPO> marketActivityGoodsPOMap = marketActivityGoodsPOList.stream().collect(Collectors.toMap(marketActivityGoodsPO -> marketActivityGoodsPO.getGoodsSkuDetailId(), marketActivityGoodsPO -> marketActivityGoodsPO));
        List goodsSkuDetailIds = marketActivityGoodsPOList.stream().map(marketActivityGoodsPO -> marketActivityGoodsPO.getGoodsSkuDetailId()).collect(Collectors.toList());
        GoodsSkuDetailPOExample goodsSkuDetailPOExample = new GoodsSkuDetailPOExample();
        goodsSkuDetailPOExample.createCriteria().andIdIn(goodsSkuDetailIds).andIsDelEqualTo(Boolean.FALSE).andIsEnabledEqualTo(Boolean.TRUE).andValidEqualTo(Boolean.TRUE);
        List goodsSkuDetailPOS = this.goodsSkuDetailPOMapper.selectByExample(goodsSkuDetailPOExample);
        if (CollectionUtils.isEmpty((Collection)goodsSkuDetailPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u5546\u54c1\u65e0sku\u4fe1\u606f\u65e0\u6cd5\u8fdb\u5165\u8be6\u60c5\u9875\u9762!");
        }
        for (GoodsSkuDetailPO goodsSkuDetailPO : goodsSkuDetailPOS) {
            Integer id = goodsSkuDetailPO.getId();
            MarketActivityGoodsPO marketActivityGoodsPO2 = marketActivityGoodsPOMap.get(id);
            MarketActivityOrdersSecKillStockPOExample marketActivityOrdersSecKillStockPOExample = new MarketActivityOrdersSecKillStockPOExample();
            marketActivityOrdersSecKillStockPOExample.createCriteria().andMarketActivityGoodsIdEqualTo(marketActivityGoodsPO2.getId()).andStatusEqualTo(Boolean.FALSE).andValidEqualTo(Boolean.TRUE);
            long count = this.marketActivityOrdersSecKillStockPOMapper.countByExample(marketActivityOrdersSecKillStockPOExample);
            goodsSkuDetailPO.setSalesPrice(marketActivityGoodsPO2.getAmount());
            Long stock = goodsSkuDetailPO.getStock().longValue();
            Long secKillStock = Math.min(stock, count);
            goodsSkuDetailPO.setStock(Integer.valueOf(secKillStock.intValue()));
        }
        User user = BizvaneSecurityContext.getUser();
        MarketActivityOrdersSecKillStockPOExample marketActivityOrdersSecKillStockPOExample = new MarketActivityOrdersSecKillStockPOExample();
        marketActivityOrdersSecKillStockPOExample.createCriteria().andMarketActivityGoodsSeckillIdEqualTo(marketActivityGoodsSecKillId).andUserNoEqualTo(user.getUserNo()).andStatusEqualTo(Boolean.TRUE).andValidEqualTo(Boolean.TRUE);
        List marketActivityOrdersSecKillStockPOList = this.marketActivityOrdersSecKillStockPOMapper.selectByExample(marketActivityOrdersSecKillStockPOExample);
        if (CollectionUtils.isEmpty((Collection)marketActivityOrdersSecKillStockPOList)) {
            marketActivitySecKillGoodDetailResponseVO.setUserBuyNum(Integer.valueOf(0));
        } else {
            marketActivitySecKillGoodDetailResponseVO.setUserBuyNum(Integer.valueOf(marketActivityOrdersSecKillStockPOList.size()));
        }
        marketActivitySecKillGoodDetailResponseVO.setGoodsSkus(goodsSkuDetailPOS);
        if (!goodsPO.getIsUniform().booleanValue()) {
            List goodsSpecRelations = this.goodsService.getGoodsSpecs(goodsId);
            marketActivitySecKillGoodDetailResponseVO.setGoodsSpecs(goodsSpecRelations);
        }
        return ResponseUtil.getSuccessData((Object)marketActivitySecKillGoodDetailResponseVO);
    }
}

