/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.seckill.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.dto.FreightCalcResponse;
import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.MarketActivityEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderActivityTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.ShippingModeEnum;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ConfigPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityGoodsSecKillPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityOrdersSecKillStockPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrderItemsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPOExample;
import com.wmeimob.fastboot.bizvane.po.ConfigPO;
import com.wmeimob.fastboot.bizvane.po.ConfigPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsSecKillPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersSecKillStockPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPO;
import com.wmeimob.fastboot.bizvane.po.OrderItemsPO;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.bizvane.service.seckill.SecKillGoodsStockService;
import com.wmeimob.fastboot.bizvane.service.seckill.SecKillOrderCheck;
import com.wmeimob.fastboot.bizvane.service.seckill.SecKillOrderFreightService;
import com.wmeimob.fastboot.bizvane.service.seckill.SecKillOrderService;
import com.wmeimob.fastboot.bizvane.vo.seckill.order.SecKillOrderItemsConfirmVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.order.SecKillOrdersConfirmVO;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import com.wmeimob.fastboot.util.DateUtil;
import com.wmeimob.fastboot.util.RandomCodeUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SecKillOrderServiceImpl
implements SecKillOrderService {
    private static final Logger log = LoggerFactory.getLogger(SecKillOrderServiceImpl.class);
    @Resource
    private MarketActivityGoodsSecKillPOMapper marketActivityGoodsSecKillPOMapper;
    @Resource
    private GoodsPOMapper goodsPOMapper;
    @Resource
    private MarketActivityPOMapper marketActivityPOMapper;
    @Resource
    private GoodsSkuDetailPOMapper goodsSkuDetailPOMapper;
    @Resource
    private MarketActivityOrdersSecKillStockPOMapper marketActivityOrdersSecKillStockPOMapper;
    @Resource
    private MarketActivityGoodsPOMapper marketActivityGoodsPOMapper;
    @Resource
    private ConfigPOMapper configPOMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private SecKillGoodsStockService secKillGoodsStockService;
    @Autowired
    private UserCommissionService userCommissionService;
    @Resource
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private SecKillOrderFreightService secKillOrderFreightService;
    @Resource
    private OrdersPOMapper ordersPOMapper;
    @Resource
    private OrderItemsPOMapper orderItemsPOMapper;
    @Resource
    private MarketActivityOrdersPOMapper marketActivityOrdersPOMapper;

    public SecKillOrdersConfirmVO confirmOrder(SecKillOrdersConfirmVO requestVO) {
        List secKillOrderItems = requestVO.getSecKillOrderItems();
        if (CollectionUtils.isEmpty((Collection)secKillOrderItems)) {
            throw new MallWechatException("\u8bf7\u9009\u62e9\u79d2\u6740\u5546\u54c1!");
        }
        User user = (User)SecurityContext.getUser();
        SecKillOrderCheck.checkUserInfo((User)user);
        BigDecimal paySum = BigDecimal.ZERO;
        for (SecKillOrderItemsConfirmVO secKillOrderItem : secKillOrderItems) {
            this.checkOrderItem(secKillOrderItem, user);
            BigDecimal itemsPayAmount = secKillOrderItem.getItemsPayAmount();
            paySum = paySum.add(itemsPayAmount);
        }
        BigDecimal shippingFee = requestVO.getShippingFee();
        BigDecimal shippingDeduction = requestVO.getShippingDeduction();
        if (shippingFee != null) {
            paySum = paySum.add(shippingFee);
            if (shippingDeduction != null) {
                paySum = paySum.subtract(shippingDeduction);
            }
        }
        requestVO.setWechatOpenid(user.getOpenid());
        requestVO.setUserId(user.getUserId());
        requestVO.setUserNo(user.getUserNo());
        requestVO.setUserName(user.getUsername());
        requestVO.setMerchantId(((SecKillOrderItemsConfirmVO)secKillOrderItems.get(0)).getMerchantId());
        requestVO.setPayAmount(paySum);
        requestVO.setOrderAmount(paySum);
        log.info("\u79d2\u6740 confirm \u8ba2\u5355:{}", (Object)JSON.toJSONString((Object)requestVO));
        return requestVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public SecKillOrdersConfirmVO confirmOrderOK(SecKillOrdersConfirmVO orders) {
        Integer merchantId = orders.getMerchantId();
        SecKillOrderCheck.checkOrdersShippingInfo((SecKillOrdersConfirmVO)orders);
        SecKillOrdersConfirmVO checkData = this.confirmOrder(orders);
        FreightCalcResponse freight = this.getFreight(orders);
        log.info("\u672c\u6b21\u751f\u6210\u90ae\u8d39\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)freight));
        if (freight.getFreightFee().compareTo(checkData.getShippingFee()) != 0 || freight.getFreightDeduction().compareTo(checkData.getShippingDeduction()) != 0) {
            throw new MallWechatException("\u4e24\u6b21\u751f\u6210\u7684\u90ae\u8d39\u4e0d\u4e00\u81f4,\u751f\u6210\u79d2\u6740\u8ba2\u5355\u5931\u8d25!");
        }
        BigDecimal sumPayAmount = BigDecimal.ZERO;
        for (SecKillOrderItemsConfirmVO secKillOrderItem : orders.getSecKillOrderItems()) {
            sumPayAmount = sumPayAmount.add(secKillOrderItem.getWepayAmount());
        }
        sumPayAmount = sumPayAmount.add(orders.getShippingFee()).subtract(orders.getShippingDeduction());
        log.info("\u6700\u65b0\u8ba1\u7b97\u8ba2\u5355\u603b\u91d1\u989d:{}", (Object)sumPayAmount);
        if (sumPayAmount.compareTo(orders.getPayAmount()) != 0) {
            throw new MallWechatException("\u8ba2\u5355\u91d1\u989d\u8ba1\u7b97\u4e0d\u6b63\u786e,\u751f\u6210\u79d2\u6740\u8ba2\u5355\u5931\u8d25");
        }
        CompanyBrandRelationPOExample companyBrandRelationPOExample = new CompanyBrandRelationPOExample();
        companyBrandRelationPOExample.createCriteria().andMerchantIdEqualTo(checkData.getMerchantId()).andValidEqualTo(Boolean.TRUE);
        List companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationPOExample);
        if (CollectionUtils.isEmpty((Collection)companyBrandRelationPOS)) {
            throw new MallWechatException("\u83b7\u53d6\u4f01\u4e1a\u4fe1\u606ferror,\u751f\u6210\u79d2\u6740\u8ba2\u5355\u5931\u8d25!");
        }
        CompanyBrandRelationPO companyBrandRelationPO = (CompanyBrandRelationPO)companyBrandRelationPOS.get(0);
        Integer companyId = companyBrandRelationPO.getCompanyId();
        Integer brandId = companyBrandRelationPO.getBrandId();
        User user = (User)SecurityContext.getUser();
        log.info("secKill-OrderController-\u8ba2\u5355\u65b0\u589econfirmOK-user:{}", (Object)JSON.toJSONString((Object)user));
        User queryUser = (User)this.userService.findOneByCondition((Serializable)user);
        log.info("secKill-OrderController-\u8ba2\u5355\u65b0\u589econfirmOK-user:{}", (Object)JSON.toJSONString((Object)queryUser));
        checkData.setUserName(queryUser.getFullName());
        checkData.setMobile(queryUser.getUserPhone());
        checkData.setOfflineStoreId(queryUser.getOfflineStoreId());
        User tempUser = new User();
        tempUser.setBrandId(queryUser.getBrandId());
        tempUser.setSysCompanyId(queryUser.getSysCompanyId());
        tempUser.setUnionid(queryUser.getUnionid());
        tempUser.setUserNo(queryUser.getUserNo());
        UserDiscountDTO memberLevel = this.userService.getUserDiscountInfo(tempUser);
        checkData.setMemberLevelName(memberLevel.getMemberLevelName());
        Boolean parentState = this.userCommissionService.findParentState(queryUser.getUserNo());
        checkData.setEnabledCommission(parentState);
        checkData.setWechatUnionId(queryUser.getUnionid());
        String userNo = checkData.getUserNo();
        JSONObject offlineMemberInfo = null;
        try {
            offlineMemberInfo = this.bizvaneInterface.getOfflineMemberInfo(companyId, brandId, userNo);
        }
        catch (Exception e) {
            log.error("bizvaneInterface_error:{}", (Throwable)e);
            throw new MallWechatException("\u83b7\u53d6\u4f1a\u5458\u7684\u7ebf\u4e0b\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        try {
            if (offlineMemberInfo != null) {
                JSONObject offlineMemberInfoJSONObject = offlineMemberInfo.getJSONObject("data");
                log.info("\u7ed9\u79d2\u6740\u8ba2\u5355\u8d4b\u503ccrm\u4f1a\u5458\u4fe1\u606f:{}", (Object)offlineMemberInfoJSONObject.toJSONString());
                String erpId = offlineMemberInfoJSONObject.getString("erpId");
                String cardNo = offlineMemberInfoJSONObject.getString("cardNo");
                String serviceStoreId = offlineMemberInfoJSONObject.getString("storeId");
                String serviceStoreCode = offlineMemberInfoJSONObject.getString("serviceStoreCode");
                String serviceGuideCode = offlineMemberInfoJSONObject.getString("serviceGuideCode");
                String serviceGuideId = offlineMemberInfoJSONObject.getString("staffId");
                String name = offlineMemberInfoJSONObject.getString("name");
                Integer sysServiceStoreId = offlineMemberInfoJSONObject.getInteger("serviceStoreId");
                checkData.setErpId(erpId);
                checkData.setOfflineCardNo(cardNo);
                checkData.setErpStoreId(serviceStoreId);
                checkData.setErpStoreCode(serviceStoreCode);
                JSONObject storeInfo = this.bizvaneInterface.getofflineStoreById(sysServiceStoreId.toString());
                String storeName = storeInfo.getString("storeName");
                checkData.setErpStoreName(storeName);
                checkData.setErpGuideCode(serviceGuideCode);
                checkData.setErpGuideId(serviceGuideId);
                checkData.setVipName(name);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7ebf\u4e0b\u4f1a\u5458\u4fe1\u606f\u5931\u8d25:{}", (Throwable)e);
        }
        checkData.setSysBrandId(companyBrandRelationPO.getBrandId());
        try {
            UserDiscountDTO userDiscountInfo = this.userService.getUserDiscountInfo(null);
            if (userDiscountInfo != null) {
                checkData.setMemberLevelName(userDiscountInfo.getMemberLevelName());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4f1a\u5458\u5361\u7b49\u7ea7\u540d\u79f0\u5931\u8d25:{}", (Throwable)e);
        }
        log.info("\u79d2\u6740\u8ba2\u5355builder\u524d:{}", (Object)JSON.toJSONString((Object)checkData));
        SecKillOrderCheck.fillOrder((SecKillOrdersConfirmVO)checkData);
        SecKillOrderCheck.fillOrderNo((SecKillOrdersConfirmVO)checkData);
        log.info("\u79d2\u6740\u8ba2\u5355builder\u540e:{}", (Object)JSON.toJSONString((Object)checkData));
        BigDecimal payAmount = checkData.getPayAmount();
        if (BigDecimal.ZERO.equals(payAmount)) {
            throw new MallWechatException("\u79d2\u6740\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a0,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String wechatOpenid = checkData.getWechatOpenid();
        List secKillOrderItems = checkData.getSecKillOrderItems();
        for (SecKillOrderItemsConfirmVO secKillOrderItem : secKillOrderItems) {
            this.secKillGoodsStockService.inventoryReduction(merchantId, secKillOrderItem, wechatOpenid, userNo);
        }
        MarketActivityOrdersPO marketActivityOrdersPO = this.builderMarketActivityOrder((SecKillOrderItemsConfirmVO)checkData.getSecKillOrderItems().get(0), userNo);
        log.info("\u65b0\u589e\u79d2\u6740\u6d3b\u52a8\u8ba2\u5355:{}", (Object)JSON.toJSONString((Object)marketActivityOrdersPO));
        OrdersPO ordersPO = new OrdersPO();
        BeanUtils.copyProperties((Object)orders, (Object)ordersPO);
        ordersPO.setMarketActivityOrdersId(marketActivityOrdersPO.getId());
        ordersPO.setOrdersActivityType(OrderActivityTypeEnum.MS.getCode().toString());
        log.info("ordersPO:{}", (Object)JSON.toJSONString((Object)ordersPO));
        this.ordersPOMapper.insertSelective(ordersPO);
        log.info("\u65b0\u589e\u79d2\u6740\u8ba2\u5355:{}", (Object)JSON.toJSONString((Object)ordersPO));
        Integer ordersPOId = ordersPO.getId();
        String orderNo = ordersPO.getOrderNo();
        for (SecKillOrderItemsConfirmVO secKillOrderItem : checkData.getSecKillOrderItems()) {
            OrderItemsPO orderItemsPO = new OrderItemsPO();
            BeanUtils.copyProperties((Object)secKillOrderItem, (Object)orderItemsPO);
            orderItemsPO.setOrderId(ordersPOId);
            orderItemsPO.setOrderNo(orderNo);
            log.info("orderItemsPO:{}", (Object)JSON.toJSONString((Object)orderItemsPO));
            this.orderItemsPOMapper.insertSelective(orderItemsPO);
            log.info("\u65b0\u589e\u79d2\u6740\u8ba2\u5355\u8be6\u60c5!!!:{}", (Object)JSON.toJSONString((Object)orderItemsPO));
        }
        log.info("\u65b0\u589e\u79d2\u6740\u8ba2\u5355item\u6210\u529f!!!");
        checkData.setId(ordersPOId);
        return checkData;
    }

    public FreightCalcResponse getFreight(SecKillOrdersConfirmVO requestVO) {
        FreightCalcResponse freightCalcResponse = new FreightCalcResponse();
        Integer shippingMode = requestVO.getShippingMode();
        String shippingProvince = requestVO.getShippingProvince();
        if (ShippingModeEnum.SELF_MENTION.getCode().equalsIgnoreCase(String.valueOf(shippingMode))) {
            log.info("\u79d2\u6740\u5546\u54c1-\u5bc4\u8d27\u5230\u5e97,\u8fd0\u8d39\u4e3a0");
            freightCalcResponse.setFreightFee(BigDecimal.ZERO);
            freightCalcResponse.setFreightDeduction(BigDecimal.ZERO);
            return freightCalcResponse;
        }
        if (ShippingModeEnum.OPTIONAL.getCode().equals(String.valueOf(shippingMode)) || StringUtils.isBlank((String)shippingProvince)) {
            log.info("\u79d2\u6740\u5546\u54c1-\u5ba2\u6237\u81ea\u9009,\u7701\u4efd\u4e3a\u7a7a,\u8fd0\u8d39\u4e3a0");
            freightCalcResponse.setFreightFee(BigDecimal.ZERO);
            freightCalcResponse.setFreightDeduction(BigDecimal.ZERO);
            return freightCalcResponse;
        }
        requestVO.setShippingProvince(SecKillOrderCheck.filterRegionName((String)requestVO.getShippingProvince(), (String)"\u7701"));
        requestVO.setShippingCity(SecKillOrderCheck.filterRegionName((String)requestVO.getShippingCity(), (String)"\u5e02"));
        requestVO.setShippingDistrict(SecKillOrderCheck.filterRegionName((String)requestVO.getShippingDistrict(), (String)"\u533a"));
        FreightCalcResponse freight = this.secKillOrderFreightService.getFreight(requestVO);
        return freight;
    }

    private void checkOrderItem(SecKillOrderItemsConfirmVO secKillOrderItemsConfirmRequest, User user) {
        Integer marketActivityGoodsSecKillId = secKillOrderItemsConfirmRequest.getMarketActivityGoodsSecKillId();
        MarketActivityGoodsSecKillPO marketActivityGoodsSecKillPO = this.marketActivityGoodsSecKillPOMapper.selectByPrimaryKey(marketActivityGoodsSecKillId);
        SecKillOrderCheck.checkSecKillGoods((MarketActivityGoodsSecKillPO)marketActivityGoodsSecKillPO);
        Integer merchantId = marketActivityGoodsSecKillPO.getMerchantId();
        Integer marketActivityId = marketActivityGoodsSecKillPO.getMarketActivityId();
        MarketActivityPO marketActivityPO = this.marketActivityPOMapper.selectByPrimaryKey(marketActivityId);
        SecKillOrderCheck.checkActivityTime((MarketActivityPO)marketActivityPO);
        Integer goodsId = marketActivityGoodsSecKillPO.getGoodsId();
        log.info("secKillOrderItemsConfirmRequest:{}", (Object)JSON.toJSONString((Object)secKillOrderItemsConfirmRequest));
        if (!goodsId.equals(secKillOrderItemsConfirmRequest.getGoodsId())) {
            throw new MallWechatException("\u79d2\u6740\u6d3b\u52a8\u5546\u54c1id\u548c\u9009\u4e2d\u5546\u54c1id\u4e0d\u4e00\u81f4!");
        }
        GoodsPO goodsPO = this.goodsPOMapper.selectByPrimaryKey(goodsId);
        SecKillOrderCheck.checkGoods((GoodsPO)goodsPO);
        Long buyCountNow = 0L;
        Integer marketActivityBuyNum = marketActivityPO.getMarketActivityBuyNum();
        if (marketActivityBuyNum != 0) {
            MarketActivityOrdersSecKillStockPOExample marketActivityOrdersSecKillStockPOExample = new MarketActivityOrdersSecKillStockPOExample();
            marketActivityOrdersSecKillStockPOExample.createCriteria().andMarketActivityGoodsSeckillIdEqualTo(marketActivityGoodsSecKillId).andUserNoEqualTo(user.getUserNo()).andValidEqualTo(Boolean.TRUE);
            buyCountNow = this.marketActivityOrdersSecKillStockPOMapper.countByExample(marketActivityOrdersSecKillStockPOExample);
        }
        SecKillOrderCheck.checkGoodsItem((MarketActivityPO)marketActivityPO, (SecKillOrderItemsConfirmVO)secKillOrderItemsConfirmRequest, (Long)buyCountNow);
        log.info("marketActivityGoodsSecKillPO:{}", (Object)JSON.toJSONString((Object)marketActivityGoodsSecKillPO));
        GoodsSkuDetailPOExample goodsSkuDetailPOExample = new GoodsSkuDetailPOExample();
        goodsSkuDetailPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andGoodsIdEqualTo(secKillOrderItemsConfirmRequest.getGoodsId()).andSkuNoEqualTo(secKillOrderItemsConfirmRequest.getSkuNo()).andIsEnabledEqualTo(Boolean.TRUE).andIsDelEqualTo(Boolean.FALSE).andValidEqualTo(Boolean.TRUE);
        List goodsSkuDetailPOS = this.goodsSkuDetailPOMapper.selectByExample(goodsSkuDetailPOExample);
        if (CollectionUtils.isEmpty((Collection)goodsSkuDetailPOS)) {
            throw new MallWechatException("sku:" + secKillOrderItemsConfirmRequest.getSkuNo() + "\u5df2\u5931\u6548,\u65e0\u6cd5\u53c2\u4e0e\u79d2\u6740\u4e0b\u5355");
        }
        GoodsSkuDetailPO skuInfo = (GoodsSkuDetailPO)goodsSkuDetailPOS.get(0);
        MarketActivityOrdersSecKillStockPOExample marketActivityOrdersSecKillStockPOExample = new MarketActivityOrdersSecKillStockPOExample();
        marketActivityOrdersSecKillStockPOExample.createCriteria().andMarketActivityGoodsSeckillIdEqualTo(marketActivityGoodsSecKillId).andSkuNoEqualTo(skuInfo.getSkuNo()).andStatusEqualTo(Boolean.FALSE).andValidEqualTo(Boolean.TRUE);
        long stockCount = this.marketActivityOrdersSecKillStockPOMapper.countByExample(marketActivityOrdersSecKillStockPOExample);
        if (stockCount == 0L || (long)secKillOrderItemsConfirmRequest.getSaleQuantity().intValue() > stockCount) {
            throw new MallWechatException("sku:" + secKillOrderItemsConfirmRequest.getSkuNo() + "\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u4e0b\u5355");
        }
        MarketActivityGoodsPOExample marketActivityGoodsPOExample = new MarketActivityGoodsPOExample();
        marketActivityGoodsPOExample.createCriteria().andMarketActivityGoodsSeckillIdEqualTo(marketActivityGoodsSecKillId).andSkuNoEqualTo(skuInfo.getSkuNo()).andValidEqualTo(Boolean.TRUE);
        List marketActivityGoodsPOList = this.marketActivityGoodsPOMapper.selectByExample(marketActivityGoodsPOExample);
        if (CollectionUtils.isEmpty((Collection)marketActivityGoodsPOList)) {
            throw new MallWechatException("sku:" + secKillOrderItemsConfirmRequest.getSkuNo() + "\u65e0\u6cd5\u53c2\u4e0e\u79d2\u6740\u6d3b\u52a8\u4e0b\u5355");
        }
        MarketActivityGoodsPO marketActivityGoodsPO = (MarketActivityGoodsPO)marketActivityGoodsPOList.get(0);
        BigDecimal pay = marketActivityGoodsPO.getAmount().multiply(BigDecimal.valueOf(secKillOrderItemsConfirmRequest.getSaleQuantity().intValue()));
        BigDecimal goodsCommissionRate = goodsPO.getCommissionRate();
        ConfigPOExample configPOExample = new ConfigPOExample();
        configPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List configPOS = this.configPOMapper.selectByExample(configPOExample);
        if (CollectionUtils.isEmpty((Collection)configPOS)) {
            throw new MallWechatException("\u751f\u6210\u8ba2\u5355\u5931\u8d25,config\u4e0d\u5b58\u5728");
        }
        ConfigPO configPO = (ConfigPO)configPOS.get(0);
        secKillOrderItemsConfirmRequest.setMarketActivityGoodsId(marketActivityGoodsPO.getId());
        secKillOrderItemsConfirmRequest.setMerchantId(merchantId);
        secKillOrderItemsConfirmRequest.setGoodsId(goodsPO.getId());
        secKillOrderItemsConfirmRequest.setGoodsName(marketActivityGoodsSecKillPO.getMarketActivityGoodsMainName());
        secKillOrderItemsConfirmRequest.setGoodsImg(marketActivityGoodsSecKillPO.getMarketActivityGoodsMainImg());
        secKillOrderItemsConfirmRequest.setGoodsSkuNo(skuInfo.getSkuNo());
        secKillOrderItemsConfirmRequest.setGoodsSkuName(skuInfo.getSpecNames());
        secKillOrderItemsConfirmRequest.setMarketPrice(skuInfo.getMarketPrice());
        secKillOrderItemsConfirmRequest.setSalePrice(marketActivityGoodsPO.getAmount());
        secKillOrderItemsConfirmRequest.setItemsAmount(pay);
        secKillOrderItemsConfirmRequest.setShippingFee(null);
        secKillOrderItemsConfirmRequest.setItemsShippingDeduction(null);
        secKillOrderItemsConfirmRequest.setUserDiscount(null);
        secKillOrderItemsConfirmRequest.setItemsUserDeduction(null);
        secKillOrderItemsConfirmRequest.setCouponDiscount(null);
        secKillOrderItemsConfirmRequest.setItemsCouponDeduction(null);
        secKillOrderItemsConfirmRequest.setActiveDiscount(null);
        secKillOrderItemsConfirmRequest.setItemsActiveDeduction(null);
        secKillOrderItemsConfirmRequest.setItemsPointDeduction(null);
        secKillOrderItemsConfirmRequest.setItemsPayAmount(pay);
        secKillOrderItemsConfirmRequest.setGmtCreate(new Date());
        if (configPO.getIsDistribution().booleanValue()) {
            if (goodsCommissionRate == null) {
                goodsCommissionRate = BigDecimal.valueOf(configPO.getCommission().intValue());
            }
            BigDecimal commission = pay.multiply(new BigDecimal("0.01")).multiply(goodsCommissionRate);
            secKillOrderItemsConfirmRequest.setCommission(commission);
        } else {
            secKillOrderItemsConfirmRequest.setCommission(BigDecimal.ZERO);
        }
        secKillOrderItemsConfirmRequest.setWepayAmount(pay);
    }

    public MarketActivityOrdersPO builderMarketActivityOrder(SecKillOrderItemsConfirmVO secKillOrderItem, String userNo) {
        Integer marketActivityGoodsSecKillId = secKillOrderItem.getMarketActivityGoodsSecKillId();
        MarketActivityGoodsSecKillPO marketActivityGoodsSecKillPO = this.marketActivityGoodsSecKillPOMapper.selectByPrimaryKey(marketActivityGoodsSecKillId);
        Integer marketActivityId = marketActivityGoodsSecKillPO.getMarketActivityId();
        MarketActivityPO marketActivityPO = this.marketActivityPOMapper.selectByPrimaryKey(marketActivityId);
        String marketActivityNo = marketActivityPO.getActivityNo();
        String activityOrdersNo = "MS" + DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss") + RandomCodeUtil.randCode((int)8);
        MarketActivityOrdersPO marketActivityOrdersPO = new MarketActivityOrdersPO();
        marketActivityOrdersPO.setActivityOrdersNo(activityOrdersNo);
        marketActivityOrdersPO.setActivityNo(marketActivityNo);
        marketActivityOrdersPO.setGoodsNo(secKillOrderItem.getGoodsNo());
        marketActivityOrdersPO.setGoodsName(marketActivityGoodsSecKillPO.getMarketActivityGoodsMainName());
        marketActivityOrdersPO.setGoodsSkuNo(secKillOrderItem.getSkuNo());
        marketActivityOrdersPO.setGoodsSkuName(secKillOrderItem.getGoodsSkuName());
        marketActivityOrdersPO.setActivityOrdersType(MarketActivityEnum.SEC_KILL.getType().toString());
        marketActivityOrdersPO.setUserNo(userNo);
        marketActivityOrdersPO.setLaunchUserNo(userNo);
        marketActivityOrdersPO.setMerchantId(secKillOrderItem.getMerchantId());
        marketActivityOrdersPO.setGoodsId(secKillOrderItem.getGoodsId());
        marketActivityOrdersPO.setMarketActivityGoodsId(secKillOrderItem.getMarketActivityGoodsId());
        marketActivityOrdersPO.setGmtCreate(new Date());
        marketActivityOrdersPO.setOrdersStatus("1");
        this.marketActivityOrdersPOMapper.insertSelective(marketActivityOrdersPO);
        return marketActivityOrdersPO;
    }
}

