/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.seckill.impl;

import com.wmeimob.fastboot.bizvane.dto.AddressInfoDTO;
import com.wmeimob.fastboot.bizvane.dto.FreightCalcDTO;
import com.wmeimob.fastboot.bizvane.dto.FreightCalcResponse;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.ExpressService;
import com.wmeimob.fastboot.bizvane.service.seckill.SecKillOrderFreightService;
import com.wmeimob.fastboot.bizvane.vo.seckill.order.SecKillOrderItemsConfirmVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.order.SecKillOrdersConfirmVO;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SecKillOrderFreightServiceImpl
implements SecKillOrderFreightService {
    private static final Logger log = LoggerFactory.getLogger(SecKillOrderFreightServiceImpl.class);
    @Autowired
    private ExpressService expressService;
    @Autowired
    private ConfigService configService;

    public FreightCalcResponse getFreight(SecKillOrdersConfirmVO orders) {
        BigDecimal freight = this.getFreightByOrderItems(AddressInfoDTO.builder().province(orders.getShippingProvince()).city(orders.getShippingCity()).district(orders.getShippingDistrict()).build(), orders.getSecKillOrderItems());
        BigDecimal deduction = this.getFreightDeduction((Orders)orders, freight);
        FreightCalcResponse freightCalcResponse = new FreightCalcResponse();
        freightCalcResponse.setFreightFee(freight);
        freightCalcResponse.setFreightDeduction(deduction);
        return freightCalcResponse;
    }

    private BigDecimal getFreightDeduction(Orders orders, BigDecimal freight) {
        Config config = this.configService.findSysConfig(orders.getMerchantId());
        if (config.getIsFreeShipping().booleanValue() && config.getFreePrice().compareTo(orders.getPayAmount()) <= 0) {
            return freight;
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getFreightByOrderItems(AddressInfoDTO addressInfoDTO, List<SecKillOrderItemsConfirmVO> orderItems) {
        return this.expressService.calcTemplate(FreightCalcDTO.builder().province(addressInfoDTO.getProvince()).city(addressInfoDTO.getCity()).area(addressInfoDTO.getDistrict()).msg(orderItems.stream().map(od -> FreightCalcDTO.Msg.builder().goodsId(od.getGoodsId()).skuNo(od.getGoodsSkuNo()).num(od.getSaleQuantity().intValue()).build()).collect(Collectors.toList())).build());
    }
}

