/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.seckill.impl;

import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.enums.OrderActivityTypeEnum;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityOrdersSecKillStockPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrderItemsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersSecKillStockPOExample;
import com.wmeimob.fastboot.bizvane.po.OrderItemsPO;
import com.wmeimob.fastboot.bizvane.po.OrderItemsPOExample;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.po.OrdersPOExample;
import com.wmeimob.fastboot.bizvane.service.seckill.SecKillGoodsStockService;
import com.wmeimob.fastboot.bizvane.vo.seckill.order.SecKillOrderItemsConfirmVO;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SecKillGoodsStockServiceImpl
implements SecKillGoodsStockService {
    private static final Logger log = LoggerFactory.getLogger(SecKillGoodsStockServiceImpl.class);
    @Resource
    private MarketActivityOrdersSecKillStockPOMapper marketActivityOrdersSecKillStockPOMapper;
    @Resource
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Resource
    private OrdersPOMapper ordersPOMapper;
    @Resource
    private OrderItemsPOMapper orderItemsPOMapper;
    @Resource
    private MarketActivityOrdersPOMapper marketActivityOrdersPOMapper;
    @Resource
    private MarketActivityGoodsPOMapper marketActivityGoodsPOMapper;

    public int inventoryReduction(Integer merchantId, SecKillOrderItemsConfirmVO secKillOrderItem, String openId, String userNo) {
        Integer marketActivityGoodsId = secKillOrderItem.getMarketActivityGoodsId();
        Integer saleQuantity = secKillOrderItem.getSaleQuantity();
        MarketActivityOrdersSecKillStockPOExample marketActivityOrdersSecKillStockPOExample = new MarketActivityOrdersSecKillStockPOExample();
        marketActivityOrdersSecKillStockPOExample.createCriteria().andMarketActivityGoodsIdEqualTo(marketActivityGoodsId).andStatusEqualTo(Boolean.FALSE).andValidEqualTo(Boolean.TRUE);
        List marketActivityOrdersSecKillStockPOList = this.marketActivityOrdersSecKillStockPOMapper.selectByExample(marketActivityOrdersSecKillStockPOExample);
        int size = 0;
        if (!CollectionUtils.isEmpty((Collection)marketActivityOrdersSecKillStockPOList)) {
            size = marketActivityOrdersSecKillStockPOList.size();
        }
        log.info("\u5f53\u524dmarketActivityGoodsId:{}\u5e93\u5b58\u6570\u4e3a:{},\u9700\u8981\u6263\u51cf\u5e93\u5b58\u6570:{}", new Object[]{marketActivityGoodsId, size, saleQuantity});
        int i = this.marketActivityOrdersSecKillStockPOMapper.inventoryReduction(marketActivityGoodsId, saleQuantity, userNo, merchantId);
        if (i != saleQuantity) {
            throw new MallWechatException("\u79d2\u6740\u6d3b\u52a8\u5546\u54c1" + secKillOrderItem.getSkuNo() + "\u5e93\u5b58\u4e0d\u8db3!");
        }
        GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
        goodsSkuDetail.setSkuNo(secKillOrderItem.getSkuNo());
        goodsSkuDetail.setGoodsId(secKillOrderItem.getGoodsId());
        goodsSkuDetail.setStock(saleQuantity);
        int i1 = this.goodsSkuDetailMapper.inventoryReduction(goodsSkuDetail);
        if (i1 != 1) {
            throw new MallWechatException("\u5546\u54c1" + secKillOrderItem.getSkuNo() + "\u5e93\u5b58\u6263\u51cf\u5931\u8d25!");
        }
        return i;
    }

    public int inventoryIncrease(String orderNo) {
        OrdersPOExample ordersPOExample = new OrdersPOExample();
        ordersPOExample.createCriteria().andOrderNoEqualTo(orderNo).andOrdersActivityTypeEqualTo(OrderActivityTypeEnum.MS.getCode().toString());
        List ordersPOS = this.ordersPOMapper.selectByExample(ordersPOExample);
        if (CollectionUtils.isEmpty((Collection)ordersPOS)) {
            return 0;
        }
        log.info("\u79d2\u6740\u8ba2\u5355:{}\u8fd4\u56de\u5e93\u5b58", (Object)orderNo);
        OrdersPO ordersPO = (OrdersPO)ordersPOS.get(0);
        Integer merchantId = ordersPO.getMerchantId();
        String userNo = ordersPO.getUserNo();
        MarketActivityOrdersPO marketActivityOrdersPO = this.marketActivityOrdersPOMapper.selectByPrimaryKey(ordersPO.getMarketActivityOrdersId());
        String activityNo = marketActivityOrdersPO.getActivityNo();
        Integer marketActivityGoodsId = marketActivityOrdersPO.getMarketActivityGoodsId();
        OrderItemsPOExample orderItemsPOExample = new OrderItemsPOExample();
        orderItemsPOExample.createCriteria().andOrderIdEqualTo(ordersPO.getId()).andValidEqualTo(Boolean.TRUE);
        List orderItemsPOS = this.orderItemsPOMapper.selectByExample(orderItemsPOExample);
        if (CollectionUtils.isEmpty((Collection)orderItemsPOS)) {
            return 0;
        }
        OrderItemsPO orderItemsPO = (OrderItemsPO)orderItemsPOS.get(0);
        Integer saleQuantity = orderItemsPO.getSaleQuantity();
        int i = this.marketActivityOrdersSecKillStockPOMapper.inventoryIncrease(marketActivityGoodsId, saleQuantity, userNo, merchantId);
        if (i != saleQuantity) {
            log.error("\u79d2\u6740\u8ba2\u5355:{}\u56de\u6edaorderItemId:{}\u8425\u9500\u5e93\u5b58\u5931\u8d25", (Object)orderNo, (Object)orderItemsPO.getId());
            throw new MallWechatException("\u65b0\u589e\u79d2\u6740\u5e93\u5b58\u5931\u8d25,\u8ba2\u5355:" + orderNo);
        }
        return i;
    }
}

